/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.theorycrafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.theorycrafting.materials.AbstractProjectMaterial;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class MaterialInstance {
    protected final AbstractProjectMaterial<?> materialDefinition;
    protected boolean selected = false;

    public static Codec<MaterialInstance> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)AbstractProjectMaterial.dispatchCodec().fieldOf("materialDefinition").forGetter(MaterialInstance::getMaterialDefinition), (App)Codec.BOOL.fieldOf("selected").forGetter(MaterialInstance::isSelected)).apply((Applicative)instance, MaterialInstance::new));
    }

    public static StreamCodec<RegistryFriendlyByteBuf, MaterialInstance> streamCodec() {
        return StreamCodec.composite(AbstractProjectMaterial.dispatchStreamCodec(), MaterialInstance::getMaterialDefinition, (StreamCodec)ByteBufCodecs.BOOL, MaterialInstance::isSelected, MaterialInstance::new);
    }

    public MaterialInstance(AbstractProjectMaterial<?> materialDefinition) {
        this(materialDefinition, false);
    }

    protected MaterialInstance(AbstractProjectMaterial<?> materialDefinition, boolean selected) {
        this.materialDefinition = materialDefinition;
        this.selected = selected;
    }

    public AbstractProjectMaterial<?> getMaterialDefinition() {
        return this.materialDefinition;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MaterialInstance)) {
            return false;
        }
        MaterialInstance that = (MaterialInstance)o;
        return this.selected == that.selected && Objects.equals(this.materialDefinition, that.materialDefinition);
    }

    public int hashCode() {
        return Objects.hash(this.materialDefinition, this.selected);
    }
}

