/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.stats;

import com.verdantartifice.primalmagick.common.crafting.IHasExpertise;
import com.verdantartifice.primalmagick.common.research.ResearchDiscipline;
import com.verdantartifice.primalmagick.common.research.ResearchDisciplines;
import com.verdantartifice.primalmagick.common.research.ResearchTier;
import com.verdantartifice.primalmagick.common.research.keys.ResearchDisciplineKey;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.runes.RuneEnchantmentDefinition;
import com.verdantartifice.primalmagick.common.runes.RuneManager;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.stats.Stat;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.HashSet;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExpertiseManager {
    private static final Logger LOGGER = LogManager.getLogger();

    public static Optional<Stat> getStat(RegistryAccess registryAccess, ResearchDisciplineKey disciplineKey) {
        ResearchDiscipline discipline = ResearchDisciplines.getDiscipline(registryAccess, disciplineKey);
        return discipline == null ? Optional.empty() : discipline.expertiseStat();
    }

    public static Optional<Integer> getThreshold(Level level, ResearchDisciplineKey disciplineKey, ResearchTier tier) {
        ResourceKey<ResearchDiscipline> rawKey = disciplineKey.getRootKey();
        if (rawKey.equals(ResearchDisciplines.BASICS) || rawKey.equals(ResearchDisciplines.SCANS)) {
            return Optional.empty();
        }
        if (rawKey.equals(ResearchDisciplines.SORCERY)) {
            return Optional.of(ExpertiseManager.getThresholdBySpellsCast(tier));
        }
        return Optional.of(ExpertiseManager.getThresholdByDisciplineRecipes(level.registryAccess(), level.getRecipeManager(), disciplineKey, tier));
    }

    protected static int getThresholdBySpellsCast(ResearchTier tier) {
        return switch (tier) {
            case ResearchTier.EXPERT -> 50;
            case ResearchTier.MASTER -> 500;
            case ResearchTier.SUPREME -> 2500;
            default -> 0;
        };
    }

    protected static int getThresholdByEnchantmentsRunescribed(RegistryAccess registryAccess, ResearchTier tier) {
        MutableInt retVal = new MutableInt(0);
        registryAccess.registryOrThrow(Registries.ENCHANTMENT).holders().forEach(ench -> RuneManager.getRuneDefinition(registryAccess, (Holder<Enchantment>)ench).ifPresent(runeEnchDef -> ExpertiseManager.getRuneEnchantmentTier(registryAccess, runeEnchDef).filter(enchTier -> enchTier.compareTo(tier) < 0).ifPresent(enchTier -> {
            int reward = enchTier.getDefaultExpertise() + enchTier.getDefaultBonusExpertise();
            retVal.add(reward);
        })));
        float multiplier = switch (tier) {
            case ResearchTier.EXPERT -> 0.2f;
            case ResearchTier.MASTER -> 0.4f;
            case ResearchTier.SUPREME -> 0.6f;
            default -> 0.0f;
        };
        int total = (int)(multiplier * (float)retVal.intValue());
        LOGGER.debug("Final expertise enchantment value for runeworking tier {}: {} ({} * {})", (Object)tier.getSerializedName(), (Object)total, (Object)retVal.intValue(), (Object)Float.valueOf(multiplier));
        return total;
    }

    protected static int getThresholdByDisciplineRecipes(RegistryAccess registryAccess, RecipeManager recipeManager, ResearchDisciplineKey discKey, ResearchTier tier) {
        HashSet foundGroups = new HashSet();
        MutableInt retVal = new MutableInt(0);
        for (RecipeHolder recipeHolder : recipeManager.getRecipes()) {
            Recipe recipe = recipeHolder.value();
            if (!(recipe instanceof IHasExpertise)) continue;
            IHasExpertise expRecipe = (IHasExpertise)recipe;
            expRecipe.getResearchDiscipline(registryAccess, recipeHolder.id()).filter(recipeDisc -> recipeDisc.equals(discKey)).ifPresent(recipeDisc -> expRecipe.getResearchTier(registryAccess).filter(recipeTier -> recipeTier.compareTo(tier) < 0).ifPresent(recipeTier -> expRecipe.getExpertiseGroup().ifPresentOrElse(groupId -> {
                if (!foundGroups.contains(groupId)) {
                    int reward = expRecipe.getExpertiseReward(registryAccess) + expRecipe.getBonusExpertiseReward(registryAccess);
                    retVal.add(reward);
                    foundGroups.add(groupId);
                }
            }, () -> {
                int reward = expRecipe.getExpertiseReward(registryAccess) + expRecipe.getBonusExpertiseReward(registryAccess);
                retVal.add(reward);
            })));
        }
        LOGGER.debug("Final expertise threshold value for {} tier {}: {}", (Object)discKey.getRootKey().location(), (Object)tier.getSerializedName(), (Object)retVal.intValue());
        return retVal.intValue();
    }

    public static Optional<Integer> getValue(@Nullable Player player, ResearchDisciplineKey disciplineKey) {
        return player == null ? Optional.empty() : ExpertiseManager.getStat(player.level().registryAccess(), disciplineKey).map(stat -> StatsManager.getValue(player, stat));
    }

    public static Optional<Integer> getValue(@Nullable Player player, @Nonnull ResourceKey<ResearchDiscipline> rawKey) {
        return ExpertiseManager.getValue(player, new ResearchDisciplineKey(rawKey));
    }

    public static void incrementValue(@Nullable Player player, ResearchDisciplineKey disciplineKey) {
        if (player != null) {
            ExpertiseManager.getStat(player.level().registryAccess(), disciplineKey).ifPresent(stat -> StatsManager.incrementValue(player, stat));
        }
    }

    public static void incrementValue(@Nullable Player player, ResearchDisciplineKey disciplineKey, int delta) {
        if (player != null) {
            ExpertiseManager.getStat(player.level().registryAccess(), disciplineKey).ifPresent(stat -> StatsManager.incrementValue(player, stat, delta));
        }
    }

    public static void setValue(@Nullable Player player, ResearchDisciplineKey disciplineKey, int value) {
        if (player != null) {
            ExpertiseManager.getStat(player.level().registryAccess(), disciplineKey).ifPresent(stat -> StatsManager.setValue(player, stat, value));
        }
    }

    public static void setValueIfMax(@Nullable Player player, ResearchDisciplineKey disciplineKey, int newVal) {
        if (player != null) {
            ExpertiseManager.getStat(player.level().registryAccess(), disciplineKey).ifPresent(stat -> StatsManager.setValueIfMax(player, stat, newVal));
        }
    }

    public static void awardExpertise(@Nullable Player player, @Nullable RecipeHolder<?> recipeHolder) {
        Recipe recipe;
        if (player != null && recipeHolder != null && (recipe = recipeHolder.value()) instanceof IHasExpertise) {
            IHasExpertise expRecipe = (IHasExpertise)recipe;
            expRecipe.getResearchDiscipline(player.level().registryAccess(), recipeHolder.id()).ifPresent(discKey -> {
                ExpertiseManager.incrementValue(player, discKey, expRecipe.getExpertiseReward(player.level().registryAccess()));
                if (ExpertiseManager.isBonusEligible(player, recipeHolder)) {
                    ExpertiseManager.incrementValue(player, discKey, expRecipe.getBonusExpertiseReward(player.level().registryAccess()));
                    ExpertiseManager.markCrafted(player, recipeHolder);
                }
            });
        }
    }

    public static boolean isBonusEligible(Player player, RecipeHolder<?> recipeHolder) {
        Recipe recipe;
        if (player != null && recipeHolder != null && (recipe = recipeHolder.value()) instanceof IHasExpertise) {
            IHasExpertise expRecipe = (IHasExpertise)recipe;
            return Services.CAPABILITIES.stats(player).map(stats -> !stats.isRecipeCrafted(recipeHolder.id()) && (expRecipe.getExpertiseGroup().isEmpty() || !stats.isRecipeGroupCrafted(expRecipe.getExpertiseGroup().get()))).orElse(false);
        }
        return false;
    }

    protected static void markCrafted(Player player, RecipeHolder<?> recipeHolder) {
        Recipe recipe;
        if (player != null && recipeHolder != null && (recipe = recipeHolder.value()) instanceof IHasExpertise) {
            IHasExpertise expRecipe = (IHasExpertise)recipe;
            Services.CAPABILITIES.stats(player).ifPresent(stats -> {
                stats.setRecipeCrafted(recipeHolder.id());
                expRecipe.getExpertiseGroup().ifPresent(stats::setRecipeGroupCrafted);
            });
        }
    }

    public static void awardExpertise(@Nullable Player player, Holder<Enchantment> enchantment) {
        if (player != null && enchantment != null) {
            ResearchDisciplineKey discKey = new ResearchDisciplineKey(ResearchDisciplines.RUNEWORKING);
            RuneManager.getRuneDefinition(player.level().registryAccess(), enchantment).ifPresent(runeEnchDef -> ExpertiseManager.getRuneEnchantmentTier(player.level().registryAccess(), runeEnchDef).ifPresent(tier -> {
                ExpertiseManager.incrementValue(player, discKey, tier.getDefaultExpertise());
                if (ExpertiseManager.isBonusEligible(player, enchantment)) {
                    ExpertiseManager.incrementValue(player, discKey, tier.getDefaultBonusExpertise());
                    ExpertiseManager.markCrafted(player, enchantment);
                }
            }));
        }
    }

    public static Optional<ResearchTier> getRuneEnchantmentTier(RegistryAccess registryAccess, RuneEnchantmentDefinition runeEnchDef) {
        Optional<ResearchTier> maxTierOpt = Optional.empty();
        for (AbstractRequirement req : runeEnchDef.getRunes().stream().map(r -> r.getRequirement()).toList()) {
            Optional<ResearchTier> tierOpt = req.getResearchTier(registryAccess);
            if (!maxTierOpt.isEmpty() && (!tierOpt.isPresent() || tierOpt.get().compareTo(maxTierOpt.get()) <= 0)) continue;
            maxTierOpt = tierOpt;
        }
        return maxTierOpt;
    }

    public static boolean isBonusEligible(Player player, Holder<Enchantment> enchantment) {
        ResourceLocation enchKey = player.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getKey((Object)((Enchantment)enchantment.value()));
        return player != null && enchKey != null && Services.CAPABILITIES.stats(player).map(stats -> !stats.isRuneEnchantmentCrafted(enchKey)).orElse(false) != false;
    }

    protected static void markCrafted(Player player, Holder<Enchantment> enchantment) {
        ResourceLocation enchKey = player.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getKey((Object)((Enchantment)enchantment.value()));
        if (player != null && enchKey != null) {
            Services.CAPABILITIES.stats(player).ifPresent(stats -> stats.setRuneEnchantmentCrafted(enchKey));
        }
    }

    public static void awardExpertise(@Nullable Player player, @Nullable SpellPackage spellPackage) {
        if (player != null && spellPackage != null) {
            ExpertiseManager.incrementValue(player, new ResearchDisciplineKey(ResearchDisciplines.SORCERY), spellPackage.getManaCost().getManaSize() / 100);
        }
    }
}

