/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.vehicles;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.MapCodec;
import com.verdantartifice.primalmagick.common.entities.projectiles.SpellProjectileEntity;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ResearchRequirement;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import com.verdantartifice.primalmagick.common.spells.SpellPropertyConfiguration;
import com.verdantartifice.primalmagick.common.spells.mods.ForkSpellMod;
import com.verdantartifice.primalmagick.common.spells.mods.SpellModsPM;
import com.verdantartifice.primalmagick.common.spells.vehicles.AbstractSpellVehicle;
import com.verdantartifice.primalmagick.common.spells.vehicles.SpellVehicleType;
import com.verdantartifice.primalmagick.common.spells.vehicles.SpellVehiclesPM;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableObject;

public class ProjectileSpellVehicle
extends AbstractSpellVehicle<ProjectileSpellVehicle> {
    public static final ProjectileSpellVehicle INSTANCE = new ProjectileSpellVehicle();
    public static final MapCodec<ProjectileSpellVehicle> CODEC = MapCodec.unit((Object)INSTANCE);
    public static final StreamCodec<ByteBuf, ProjectileSpellVehicle> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);
    public static final String TYPE = "projectile";
    protected static final AbstractRequirement<?> REQUIREMENT = new ResearchRequirement(new ResearchEntryKey(ResearchEntries.SPELL_VEHICLE_PROJECTILE));

    public static AbstractRequirement<?> getRequirement() {
        return REQUIREMENT;
    }

    public static ProjectileSpellVehicle getInstance() {
        return INSTANCE;
    }

    @Override
    public SpellVehicleType<ProjectileSpellVehicle> getType() {
        return SpellVehiclesPM.PROJECTILE.get();
    }

    @Override
    protected List<SpellProperty> getPropertiesInner() {
        return ImmutableList.of();
    }

    @Override
    protected String getVehicleType() {
        return TYPE;
    }

    @Override
    public void execute(SpellPackage spell, Level world, LivingEntity caster, ItemStack spellSource) {
        if (spell.payload() != null) {
            Vec3 baseLookVector = caster.getViewVector(1.0f);
            MutableObject lookVectors = new MutableObject();
            spell.getMod(SpellModsPM.FORK.get()).ifPresentOrElse(forkMod -> lookVectors.setValue(((ForkSpellMod)forkMod.getComponent()).getDirectionUnitVectors(baseLookVector, world.random, spell, spellSource)), () -> lookVectors.setValue(Arrays.asList(baseLookVector.normalize())));
            for (Vec3 lookVector : (List)lookVectors.getValue()) {
                SpellProjectileEntity projectile = new SpellProjectileEntity(world, caster, spell, spellSource);
                projectile.shoot(lookVector.x, lookVector.y, lookVector.z, 1.5f, 0.0f);
                world.addFreshEntity((Entity)projectile);
            }
        }
    }

    @Override
    public int getBaseManaCostModifier(SpellPropertyConfiguration properties) {
        return 0;
    }

    @Override
    public int getManaCostMultiplier(SpellPropertyConfiguration properties) {
        return 2;
    }

    @Override
    public boolean isIndirect() {
        return true;
    }
}

