/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.vehicles;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.spells.AbstractConfiguredSpellComponent;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import com.verdantartifice.primalmagick.common.spells.SpellPropertyConfiguration;
import com.verdantartifice.primalmagick.common.spells.vehicles.AbstractSpellVehicle;
import com.verdantartifice.primalmagick.common.spells.vehicles.EmptySpellVehicle;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class ConfiguredSpellVehicle<T extends AbstractSpellVehicle<?>>
extends AbstractConfiguredSpellComponent<T> {
    public ConfiguredSpellVehicle(T vehicle) {
        super(vehicle);
    }

    public ConfiguredSpellVehicle(T vehicle, Map<SpellProperty, Integer> configuredProperties) {
        super(vehicle, configuredProperties);
    }

    public ConfiguredSpellVehicle(T vehicle, SpellPropertyConfiguration configuredProperties) {
        super(vehicle, configuredProperties);
    }

    public static Codec<ConfiguredSpellVehicle<?>> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)AbstractSpellVehicle.dispatchCodec().fieldOf("vehicle").forGetter(AbstractConfiguredSpellComponent::getComponent), (App)SpellPropertyConfiguration.CODEC.fieldOf("properties").forGetter(csc -> csc.configuredProperties)).apply((Applicative)instance, ConfiguredSpellVehicle::new));
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ConfiguredSpellVehicle<?>> streamCodec() {
        return StreamCodec.composite(AbstractSpellVehicle.dispatchStreamCodec(), AbstractConfiguredSpellComponent::getComponent, SpellPropertyConfiguration.STREAM_CODEC, csc -> csc.configuredProperties, ConfiguredSpellVehicle::new);
    }

    public int getBaseManaCostModifier() {
        return ((AbstractSpellVehicle)this.component).getBaseManaCostModifier(this.configuredProperties);
    }

    public int getManaCostMultiplier() {
        return ((AbstractSpellVehicle)this.component).getManaCostMultiplier(this.configuredProperties);
    }

    public static Builder builder(SpellPackage.Builder parent) {
        return new Builder(parent);
    }

    public static class Builder {
        protected final SpellPackage.Builder parent;
        protected AbstractSpellVehicle<?> vehicle = EmptySpellVehicle.INSTANCE;
        protected final Map<SpellProperty, Integer> properties = new HashMap<SpellProperty, Integer>();

        public Builder(SpellPackage.Builder parent) {
            this.parent = parent;
        }

        public Builder type(AbstractSpellVehicle<?> vehicle) {
            this.vehicle = vehicle;
            return this;
        }

        public Builder with(SpellProperty property, int value) {
            this.properties.put(property, value);
            return this;
        }

        private void validate() {
            if (this.vehicle == null) {
                throw new IllegalStateException("No type specified for spell vehicle");
            }
        }

        public ConfiguredSpellVehicle<?> build() {
            this.validate();
            return new ConfiguredSpellVehicle(this.vehicle, this.properties);
        }

        public SpellPackage.Builder end() {
            return this.parent;
        }
    }
}

