/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.vehicles;

import com.mojang.serialization.MapCodec;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.SpellBoltPacket;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ResearchRequirement;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.SpellPropertiesPM;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import com.verdantartifice.primalmagick.common.spells.SpellPropertyConfiguration;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractSpellPayload;
import com.verdantartifice.primalmagick.common.spells.vehicles.AbstractRaycastSpellVehicle;
import com.verdantartifice.primalmagick.common.spells.vehicles.SpellVehicleType;
import com.verdantartifice.primalmagick.common.spells.vehicles.SpellVehiclesPM;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BoltSpellVehicle
extends AbstractRaycastSpellVehicle<BoltSpellVehicle> {
    public static final BoltSpellVehicle INSTANCE = new BoltSpellVehicle();
    public static final MapCodec<BoltSpellVehicle> CODEC = MapCodec.unit((Object)INSTANCE);
    public static final StreamCodec<ByteBuf, BoltSpellVehicle> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);
    public static final String TYPE = "bolt";
    protected static final AbstractRequirement<?> REQUIREMENT = new ResearchRequirement(new ResearchEntryKey(ResearchEntries.SPELL_VEHICLE_BOLT));
    protected static final Supplier<List<SpellProperty>> PROPERTIES = () -> Arrays.asList(SpellPropertiesPM.RANGE.get());

    public static AbstractRequirement<?> getRequirement() {
        return REQUIREMENT;
    }

    public static BoltSpellVehicle getInstance() {
        return INSTANCE;
    }

    @Override
    public SpellVehicleType<BoltSpellVehicle> getType() {
        return SpellVehiclesPM.BOLT.get();
    }

    @Override
    protected List<SpellProperty> getPropertiesInner() {
        return PROPERTIES.get();
    }

    @Override
    protected double getReachDistance(LivingEntity caster, SpellPackage spell, ItemStack spellSource) {
        return this.getRangeBlocks(spell, spellSource);
    }

    @Override
    protected String getVehicleType() {
        return TYPE;
    }

    @Override
    public int getBaseManaCostModifier(SpellPropertyConfiguration properties) {
        return properties.get(SpellPropertiesPM.RANGE.get());
    }

    @Override
    protected void drawFx(Level world, SpellPackage spell, Vec3 source, Vec3 target) {
        if (spell.payload() != null && world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            PacketHandler.sendToAllAround(new SpellBoltPacket(source, target, ((AbstractSpellPayload)spell.payload().getComponent()).getSource().getColor()), serverLevel, BlockPos.containing((Position)source), 64.0);
        }
    }

    protected int getRangeBlocks(SpellPackage spell, ItemStack spellSource) {
        return 6 + 2 * spell.vehicle().getPropertyValue(SpellPropertiesPM.RANGE.get());
    }

    @Override
    public Component getDetailTooltip(SpellPackage spell, ItemStack spellSource, LivingEntity caster, HolderLookup.Provider registries) {
        return Component.translatable((String)("spells.primalmagick.vehicle." + this.getVehicleType() + ".detail_tooltip"), (Object[])new Object[]{this.getRangeBlocks(spell, spellSource)});
    }

    @Override
    public boolean isIndirect() {
        return true;
    }
}

