/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.vehicles;

import com.mojang.serialization.Codec;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import com.verdantartifice.primalmagick.common.spells.SpellPropertyConfiguration;
import com.verdantartifice.primalmagick.common.spells.vehicles.ISpellVehicle;
import com.verdantartifice.primalmagick.common.spells.vehicles.SpellVehicleType;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractSpellVehicle<T extends AbstractSpellVehicle<T>>
implements ISpellVehicle {
    public static Codec<AbstractSpellVehicle<?>> dispatchCodec() {
        return Services.SPELL_VEHICLE_TYPES_REGISTRY.codec().dispatch("mod_type", AbstractSpellVehicle::getType, SpellVehicleType::codec);
    }

    public static StreamCodec<RegistryFriendlyByteBuf, AbstractSpellVehicle<?>> dispatchStreamCodec() {
        return Services.SPELL_VEHICLE_TYPES_REGISTRY.registryFriendlyStreamCodec().dispatch(AbstractSpellVehicle::getType, SpellVehicleType::streamCodec);
    }

    public abstract SpellVehicleType<T> getType();

    protected abstract String getVehicleType();

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public Component getTypeName() {
        return Component.translatable((String)("spells.primalmagick.vehicle." + this.getVehicleType() + ".type"));
    }

    @Override
    public Component getDefaultNamePiece() {
        return Component.translatable((String)("spells.primalmagick.vehicle." + this.getVehicleType() + ".default_name"));
    }

    @Override
    public int getBaseManaCostModifier(SpellPropertyConfiguration properties) {
        return 0;
    }

    @Override
    public int getManaCostMultiplier(SpellPropertyConfiguration properties) {
        return 1;
    }

    @Override
    public List<SpellProperty> getProperties() {
        return this.getPropertiesInner().stream().sorted(Comparator.comparing(SpellProperty::id)).collect(Collectors.toList());
    }

    protected abstract List<SpellProperty> getPropertiesInner();

    @Override
    public SpellProperty getProperty(ResourceLocation id) {
        return this.getPropertiesInner().stream().filter(prop -> prop.id().equals((Object)id)).findFirst().orElse(null);
    }
}

