/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.vehicles;

import com.verdantartifice.primalmagick.common.spells.SpellManager;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.mods.ForkSpellMod;
import com.verdantartifice.primalmagick.common.spells.mods.SpellModsPM;
import com.verdantartifice.primalmagick.common.spells.vehicles.AbstractSpellVehicle;
import com.verdantartifice.primalmagick.common.util.RayTraceUtils;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableObject;

public abstract class AbstractRaycastSpellVehicle<T extends AbstractRaycastSpellVehicle<T>>
extends AbstractSpellVehicle<T> {
    protected abstract double getReachDistance(@Nonnull LivingEntity var1, @Nonnull SpellPackage var2, @Nonnull ItemStack var3);

    protected void drawFx(@Nonnull Level world, @Nonnull SpellPackage spell, Vec3 source, Vec3 target) {
    }

    @Override
    public void execute(SpellPackage spell, Level world, LivingEntity caster, ItemStack spellSource) {
        if (spell.payload() != null) {
            Vec3 baseLookVector = caster.getViewVector(1.0f);
            MutableObject lookVectors = new MutableObject();
            spell.getMod(SpellModsPM.FORK.get()).ifPresentOrElse(forkMod -> lookVectors.setValue(((ForkSpellMod)forkMod.getComponent()).getDirectionUnitVectors(baseLookVector, world.random, spell, spellSource)), () -> lookVectors.setValue(Arrays.asList(baseLookVector.normalize())));
            double reachDistance = this.getReachDistance(caster, spell, spellSource);
            Vec3 eyePos = caster.getEyePosition(1.0f);
            for (Vec3 lookVector : (List)lookVectors.getValue()) {
                Vec3 reachPos = eyePos.add(lookVector.scale(reachDistance));
                AABB aabb = caster.getBoundingBox().expandTowards(lookVector.scale(reachDistance)).inflate(1.0, 1.0, 1.0);
                EntityHitResult entityResult = RayTraceUtils.rayTraceEntities(world, (Entity)caster, eyePos, reachPos, aabb, testEntity -> !testEntity.isSpectator(), reachDistance * reachDistance);
                BlockHitResult blockResult = world.clip(new ClipContext(eyePos, reachPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)caster));
                Object result = entityResult == null ? blockResult : (eyePos.distanceToSqr(entityResult.getLocation()) <= eyePos.distanceToSqr(blockResult.getLocation()) ? entityResult : blockResult);
                this.drawFx(world, spell, eyePos.add(lookVector.scale(0.1)), result.getLocation());
                SpellManager.executeSpellPayload(spell, (HitResult)result, world, caster, spellSource, true, null);
            }
        }
    }
}

