/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.payloads;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.MapCodec;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ResearchRequirement;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.SpellPropertiesPM;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import com.verdantartifice.primalmagick.common.spells.SpellPropertyConfiguration;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractDamageSpellPayload;
import com.verdantartifice.primalmagick.common.spells.payloads.SpellPayloadType;
import com.verdantartifice.primalmagick.common.spells.payloads.SpellPayloadsPM;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class VoidDamageSpellPayload
extends AbstractDamageSpellPayload<VoidDamageSpellPayload> {
    public static final VoidDamageSpellPayload INSTANCE = new VoidDamageSpellPayload();
    public static final MapCodec<VoidDamageSpellPayload> CODEC = MapCodec.unit((Object)INSTANCE);
    public static final StreamCodec<ByteBuf, VoidDamageSpellPayload> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);
    public static final String TYPE = "void_damage";
    protected static final AbstractRequirement<?> REQUIREMENT = new ResearchRequirement(new ResearchEntryKey(ResearchEntries.SPELL_PAYLOAD_VOID));

    public static AbstractRequirement<?> getRequirement() {
        return REQUIREMENT;
    }

    public static VoidDamageSpellPayload getInstance() {
        return INSTANCE;
    }

    @Override
    protected List<SpellProperty> getPropertiesInner() {
        return ImmutableList.builder().addAll(super.getPropertiesInner()).add((Object)SpellPropertiesPM.DURATION.get()).build();
    }

    @Override
    public SpellPayloadType<VoidDamageSpellPayload> getType() {
        return SpellPayloadsPM.VOID_DAMAGE.get();
    }

    @Override
    public Source getSource() {
        return Sources.VOID;
    }

    @Override
    public void playSounds(Level world, BlockPos origin) {
        world.playSound(null, origin, SoundsPM.WHISPERS.get(), SoundSource.PLAYERS, 1.0f, 1.0f + (float)(world.random.nextGaussian() * 0.05));
    }

    @Override
    protected String getPayloadType() {
        return TYPE;
    }

    @Override
    protected void applySecondaryEffects(HitResult target, Vec3 burstPoint, SpellPackage spell, Level world, LivingEntity caster, ItemStack spellSource) {
        EntityHitResult entityTarget;
        int duration = this.getDurationSeconds(spell, spellSource, caster, (HolderLookup.Provider)world.registryAccess());
        if (target != null && target.getType() == HitResult.Type.ENTITY && duration > 0 && (entityTarget = (EntityHitResult)target).getEntity() != null && entityTarget.getEntity() instanceof LivingEntity) {
            int potency = (int)((1.0f + (float)this.getModdedPropertyValue(SpellPropertiesPM.POWER.get(), spell, spellSource, caster, (HolderLookup.Provider)world.registryAccess())) / 3.0f);
            ((LivingEntity)entityTarget.getEntity()).addEffect(new MobEffectInstance(MobEffects.WITHER, 20 * duration, potency));
        }
    }

    @Override
    public int getBaseManaCost(SpellPropertyConfiguration properties) {
        int power = properties.get(SpellPropertiesPM.POWER.get());
        int duration = properties.get(SpellPropertiesPM.DURATION.get());
        return (1 << Math.max(0, power - 1)) + (duration == 0 ? 0 : 1 << Math.max(0, duration - 1) >> 1);
    }

    protected int getDurationSeconds(SpellPackage spell, ItemStack spellSource, LivingEntity caster, HolderLookup.Provider registries) {
        return 2 * this.getModdedPropertyValue(SpellPropertiesPM.DURATION.get(), spell, spellSource, caster, registries);
    }

    @Override
    public Component getDetailTooltip(SpellPackage spell, ItemStack spellSource, LivingEntity caster, HolderLookup.Provider registries) {
        return Component.translatable((String)("spells.primalmagick.payload." + this.getPayloadType() + ".detail_tooltip"), (Object[])new Object[]{DECIMAL_FORMATTER.format(this.getBaseDamage(spell, spellSource, null, registries)), DECIMAL_FORMATTER.format(this.getDurationSeconds(spell, spellSource, caster, registries))});
    }
}

