/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.payloads;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.MapCodec;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentHelperPM;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentsPM;
import com.verdantartifice.primalmagick.common.misc.BlockBreaker;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ResearchRequirement;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import com.verdantartifice.primalmagick.common.spells.SpellPropertyConfiguration;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractSpellPayload;
import com.verdantartifice.primalmagick.common.spells.payloads.SpellPayloadType;
import com.verdantartifice.primalmagick.common.spells.payloads.SpellPayloadsPM;
import com.verdantartifice.primalmagick.common.tags.BlockExtensionTags;
import com.verdantartifice.primalmagick.platform.Services;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.TripWireBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ShearSpellPayload
extends AbstractSpellPayload<ShearSpellPayload> {
    public static final ShearSpellPayload INSTANCE = new ShearSpellPayload();
    public static final MapCodec<ShearSpellPayload> CODEC = MapCodec.unit((Object)INSTANCE);
    public static final StreamCodec<ByteBuf, ShearSpellPayload> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);
    public static final String TYPE = "shear";
    protected static final AbstractRequirement<?> REQUIREMENT = new ResearchRequirement(new ResearchEntryKey(ResearchEntries.SPELL_PAYLOAD_SHEAR));

    public static AbstractRequirement<?> getRequirement() {
        return REQUIREMENT;
    }

    public static ShearSpellPayload getInstance() {
        return INSTANCE;
    }

    @Override
    public SpellPayloadType<ShearSpellPayload> getType() {
        return SpellPayloadsPM.SHEAR.get();
    }

    @Override
    protected List<SpellProperty> getPropertiesInner() {
        return ImmutableList.of();
    }

    @Override
    public void execute(HitResult target, Vec3 burstPoint, SpellPackage spell, Level world, LivingEntity caster, ItemStack spellSource, Entity projectileEntity) {
        ItemStack fakeShears = new ItemStack((ItemLike)Items.SHEARS);
        RandomSource rand = world.random;
        int treasureLevel = EnchantmentHelperPM.getEnchantmentLevel(spellSource, EnchantmentsPM.TREASURE, (HolderLookup.Provider)world.registryAccess());
        if (caster instanceof Player) {
            Player player = (Player)caster;
            if (target.getType() == HitResult.Type.ENTITY) {
                EntityHitResult entityHitResult = (EntityHitResult)target;
                Entity entity = entityHitResult.getEntity();
                if (Services.SHEARABLE.isShearable(entity, player, fakeShears, world, entity.blockPosition())) {
                    List<ItemStack> drops = Services.SHEARABLE.onSheared(entity, player, ItemStack.EMPTY, world, entity.blockPosition(), treasureLevel);
                    drops.forEach(d -> {
                        ItemEntity ent = entity.spawnAtLocation(d, 1.0f);
                        ent.setDeltaMovement(ent.getDeltaMovement().add((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                    });
                }
            } else if (target.getType() == HitResult.Type.BLOCK) {
                UseOnContext fakeContext;
                BlockHitResult blockTarget = (BlockHitResult)target;
                BlockPos pos = blockTarget.getBlockPos();
                BlockState state = world.getBlockState(pos);
                BlockState modifiedState = Services.BLOCK_STATES.getShearsModifiedState(state, fakeContext = new UseOnContext(world, player, InteractionHand.MAIN_HAND, fakeShears, blockTarget), true);
                if (modifiedState != null) {
                    world.setBlock(pos, modifiedState, 11);
                    world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)modifiedState));
                    return;
                }
                Block block = state.getBlock();
                if (block instanceof TripWireBlock) {
                    TripWireBlock tripwire = (TripWireBlock)block;
                    FluidState fluid = world.getFluidState(pos);
                    world.setBlock(pos, (BlockState)state.setValue((Property)TripWireBlock.DISARMED, (Comparable)Boolean.TRUE), 4);
                    world.gameEvent((Entity)player, (Holder)GameEvent.SHEAR, pos);
                    if (world.setBlock(pos, fluid.createLegacyBlock(), world.isClientSide ? 11 : 3)) {
                        tripwire.destroy((LevelAccessor)world, pos, state);
                    }
                }
                if ((block = state.getBlock()) instanceof BeehiveBlock) {
                    BeehiveBlock beehive = (BeehiveBlock)block;
                    if ((Integer)state.getValue((Property)BeehiveBlock.HONEY_LEVEL) >= 5) {
                        world.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BEEHIVE_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
                        BeehiveBlock.dropHoneycomb((Level)world, (BlockPos)pos);
                        world.gameEvent((Entity)player, (Holder)GameEvent.SHEAR, pos);
                        if (!CampfireBlock.isSmokeyPos((Level)world, (BlockPos)pos)) {
                            if (beehive.hiveContainsBees(world, pos)) {
                                beehive.angerNearbyBees(world, pos);
                            }
                            beehive.releaseBeesAndResetHoneyLevel(world, state, pos, player, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
                        } else {
                            beehive.resetHoneyLevel(world, state, pos);
                        }
                    }
                }
                if (world.getBlockState(pos).is(BlockExtensionTags.MINEABLE_WITH_SHEARS)) {
                    BlockBreaker breaker = new BlockBreaker.Builder().power(5.0f).target(pos, state).durability(1.0f).player(player).tool(fakeShears).fortune(treasureLevel).alwaysDrop().build();
                    BlockBreaker.schedule(world, 1, breaker);
                }
            }
        }
    }

    @Override
    public Source getSource() {
        return Sources.SKY;
    }

    @Override
    public int getBaseManaCost(SpellPropertyConfiguration properties) {
        return 5;
    }

    @Override
    public void playSounds(Level world, BlockPos origin) {
        world.playSound(null, origin, SoundEvents.SHEEP_SHEAR, SoundSource.PLAYERS, 1.0f, 1.0f + (float)(world.random.nextGaussian() * 0.05));
    }

    @Override
    protected String getPayloadType() {
        return TYPE;
    }
}

