/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.payloads;

import com.mojang.serialization.MapCodec;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ResearchRequirement;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.SpellPropertiesPM;
import com.verdantartifice.primalmagick.common.spells.SpellPropertyConfiguration;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractDamageSpellPayload;
import com.verdantartifice.primalmagick.common.spells.payloads.SpellPayloadType;
import com.verdantartifice.primalmagick.common.spells.payloads.SpellPayloadsPM;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EarthDamageSpellPayload
extends AbstractDamageSpellPayload<EarthDamageSpellPayload> {
    public static final EarthDamageSpellPayload INSTANCE = new EarthDamageSpellPayload();
    public static final MapCodec<EarthDamageSpellPayload> CODEC = MapCodec.unit((Object)INSTANCE);
    public static final StreamCodec<ByteBuf, EarthDamageSpellPayload> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);
    public static final String TYPE = "earth_damage";
    protected static final AbstractRequirement<?> REQUIREMENT = new ResearchRequirement(new ResearchEntryKey(ResearchEntries.BASIC_SORCERY));

    public static AbstractRequirement<?> getRequirement() {
        return REQUIREMENT;
    }

    public static EarthDamageSpellPayload getInstance() {
        return INSTANCE;
    }

    @Override
    public SpellPayloadType<EarthDamageSpellPayload> getType() {
        return SpellPayloadsPM.EARTH_DAMAGE.get();
    }

    @Override
    protected String getPayloadType() {
        return TYPE;
    }

    @Override
    public Source getSource() {
        return Sources.EARTH;
    }

    @Override
    protected void applySecondaryEffects(HitResult target, Vec3 burstPoint, SpellPackage spell, Level world, LivingEntity caster, ItemStack spellSource) {
        Entity entity;
        EntityHitResult entityTarget;
        if (target != null && target.getType() == HitResult.Type.ENTITY && (entityTarget = (EntityHitResult)target).getEntity() != null && (entity = entityTarget.getEntity()) instanceof LivingEntity) {
            Vec3 knockbackVec;
            LivingEntity livingTarget = (LivingEntity)entity;
            if (entityTarget.getEntity().equals((Object)caster)) {
                knockbackVec = caster.getLookAngle().scale(-1.0).normalize();
            } else {
                Vec3 knockbackSource = burstPoint == null || burstPoint.equals((Object)target.getLocation()) ? caster.getEyePosition(1.0f) : burstPoint;
                knockbackVec = target.getLocation().subtract(knockbackSource).scale(-1.0).normalize();
            }
            livingTarget.knockback((double)(0.25f * this.getTotalDamage(entityTarget.getEntity(), spell, spellSource, null, (HolderLookup.Provider)world.registryAccess())), knockbackVec.x, knockbackVec.z);
        }
    }

    @Override
    public void playSounds(Level world, BlockPos origin) {
        world.playSound(null, origin, SoundsPM.ROCKSLIDE.get(), SoundSource.PLAYERS, 1.0f, 1.0f + (float)(world.random.nextGaussian() * 0.05));
    }

    @Override
    public int getBaseManaCost(SpellPropertyConfiguration properties) {
        int power = properties.get(SpellPropertiesPM.POWER.get());
        return (1 << Math.max(0, power - 1)) + (1 << Math.max(0, power - 1) >> 1);
    }

    @Override
    public Component getDetailTooltip(SpellPackage spell, ItemStack spellSource, LivingEntity caster, HolderLookup.Provider registries) {
        return Component.translatable((String)("spells.primalmagick.payload." + this.getPayloadType() + ".detail_tooltip"), (Object[])new Object[]{DECIMAL_FORMATTER.format(this.getBaseDamage(spell, spellSource, null, registries))});
    }
}

