/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.payloads;

import com.verdantartifice.primalmagick.common.damagesource.DamageSourcesPM;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.SpellPropertiesPM;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractSpellPayload;
import com.verdantartifice.primalmagick.common.spells.vehicles.AbstractSpellVehicle;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractDamageSpellPayload<T extends AbstractDamageSpellPayload<T>>
extends AbstractSpellPayload<T> {
    private static final Supplier<List<SpellProperty>> PROPERTIES = () -> Arrays.asList(SpellPropertiesPM.POWER.get());

    @Override
    protected List<SpellProperty> getPropertiesInner() {
        return PROPERTIES.get();
    }

    protected float getBaseDamage(SpellPackage spell, @Nullable ItemStack spellSource, @Nullable LivingEntity caster, HolderLookup.Provider registries) {
        return 4.0f + 3.0f * (float)this.getModdedPropertyValue(SpellPropertiesPM.POWER.get(), spell, spellSource, caster, registries);
    }

    protected float getTotalDamage(Entity target, SpellPackage spell, @Nullable ItemStack spellSource, @Nullable LivingEntity caster, HolderLookup.Provider registries) {
        float damage = this.getBaseDamage(spell, spellSource, caster, registries);
        if (target instanceof Player) {
            damage *= 0.5f;
        }
        return damage;
    }

    protected DamageSource getDamageSource(LivingEntity source, SpellPackage spell, Entity projectileEntity) {
        Level level = source.level();
        if (projectileEntity != null) {
            return DamageSourcesPM.sorcery(level.registryAccess(), this.getSource(), projectileEntity, source);
        }
        if (((AbstractSpellVehicle)spell.vehicle().getComponent()).isIndirect()) {
            return DamageSourcesPM.sorcery(level.registryAccess(), this.getSource(), null, source);
        }
        return DamageSourcesPM.sorcery(level.registryAccess(), this.getSource(), source);
    }

    @Override
    public void execute(HitResult target, Vec3 burstPoint, SpellPackage spell, Level world, LivingEntity caster, ItemStack spellSource, Entity projectileEntity) {
        EntityHitResult entityTarget;
        if (target != null && target.getType() == HitResult.Type.ENTITY && (entityTarget = (EntityHitResult)target).getEntity() != null) {
            entityTarget.getEntity().hurt(this.getDamageSource(caster, spell, projectileEntity), this.getTotalDamage(entityTarget.getEntity(), spell, spellSource, caster, (HolderLookup.Provider)world.registryAccess()));
            if (caster != null) {
                caster.setLastHurtMob(entityTarget.getEntity());
            }
        }
        this.applySecondaryEffects(target, burstPoint, spell, world, caster, spellSource);
    }

    protected void applySecondaryEffects(@Nullable HitResult target, @Nullable Vec3 burstPoint, @Nonnull SpellPackage spell, @Nonnull Level world, @Nonnull LivingEntity caster, @Nullable ItemStack spellSource) {
    }
}

