/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.payloads;

import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractSpellPayload;
import com.verdantartifice.primalmagick.common.util.RayTraceUtils;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractConjureFluidSpellPayload<T extends AbstractConjureFluidSpellPayload<T>>
extends AbstractSpellPayload<T> {
    protected final FlowingFluid fluid;

    protected AbstractConjureFluidSpellPayload(FlowingFluid fluid) {
        this.fluid = fluid;
    }

    @Override
    public void execute(HitResult target, Vec3 burstPoint, SpellPackage spell, Level world, LivingEntity caster, ItemStack spellSource, Entity projectileEntity) {
        if (!(caster instanceof Player)) {
            return;
        }
        Player player = (Player)caster;
        if (target != null) {
            BlockHitResult blockTarget;
            ItemStack stack = this.getSimulatedItemStack((Fluid)this.fluid);
            if (target.getType() == HitResult.Type.BLOCK) {
                BlockHitResult blockTarget2 = (BlockHitResult)target;
                BlockPos targetPos = blockTarget2.getBlockPos();
                if (world.mayInteract(player, targetPos) && player.mayUseItemAt(targetPos, blockTarget2.getDirection(), stack)) {
                    BlockState state = world.getBlockState(targetPos);
                    BlockPos placePos = state.getBlock() instanceof LiquidBlockContainer && this.fluid == Fluids.WATER ? targetPos : targetPos.relative(blockTarget2.getDirection());
                    this.placeFluid(player, world, placePos, blockTarget2);
                }
            } else if (target.getType() == HitResult.Type.ENTITY && world.mayInteract(player, (blockTarget = RayTraceUtils.getBlockResultFromEntityResult((EntityHitResult)target)).getBlockPos()) && player.mayUseItemAt(blockTarget.getBlockPos(), blockTarget.getDirection(), stack)) {
                this.placeFluid(player, world, blockTarget.getBlockPos(), blockTarget);
            }
        }
    }

    protected ItemStack getSimulatedItemStack(@Nonnull Fluid fluid) {
        if (fluid.is(FluidTags.WATER)) {
            return new ItemStack((ItemLike)Items.WATER_BUCKET);
        }
        if (fluid.is(FluidTags.LAVA)) {
            return new ItemStack((ItemLike)Items.LAVA_BUCKET);
        }
        return ItemStack.EMPTY;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void placeFluid(Player player, Level world, BlockPos pos, BlockHitResult blockTarget) {
        LiquidBlockContainer lbc;
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        boolean isSolid = state.isSolid();
        boolean isReplaceable = state.canBeReplaced();
        if (world.isEmptyBlock(pos) || !isSolid || isReplaceable || block instanceof LiquidBlockContainer && (lbc = (LiquidBlockContainer)block).canPlaceLiquid(player, (BlockGetter)world, pos, state, (Fluid)this.fluid)) {
            if (world.dimensionType().ultraWarm() && this.fluid.is(FluidTags.WATER)) {
                return;
            }
            if (block instanceof LiquidBlockContainer) {
                LiquidBlockContainer lbc2 = (LiquidBlockContainer)block;
                if (this.fluid == Fluids.WATER) {
                    lbc2.placeLiquid((LevelAccessor)world, pos, state, this.fluid.getSource(false));
                    return;
                }
            }
            if (!(world.isClientSide || isSolid && !isReplaceable || state.liquid())) {
                world.destroyBlock(pos, true);
            }
            world.setBlock(pos, this.fluid.defaultFluidState().createLegacyBlock(), 11);
            return;
        }
        if (blockTarget == null) return;
        this.placeFluid(player, world, blockTarget.getBlockPos().relative(blockTarget.getDirection()), null);
    }
}

