/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.payloads;

import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractSpellPayload;
import com.verdantartifice.primalmagick.common.util.RayTraceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractConjureBlockSpellPayload<T extends AbstractConjureBlockSpellPayload<T>>
extends AbstractSpellPayload<T> {
    protected final Supplier<BlockState> targetStateSupplier;
    protected final int count;

    protected AbstractConjureBlockSpellPayload(Supplier<BlockState> targetState) {
        this(targetState, 1);
    }

    protected AbstractConjureBlockSpellPayload(Supplier<BlockState> targetState, int count) {
        this.targetStateSupplier = targetState;
        this.count = count;
    }

    @Override
    public void execute(HitResult target, Vec3 burstPoint, SpellPackage spell, Level world, LivingEntity caster, ItemStack spellSource, Entity projectileEntity) {
        if (!(caster instanceof Player)) {
            return;
        }
        Player player = (Player)caster;
        if (target != null) {
            if (target.getType() == HitResult.Type.BLOCK) {
                this.executeInner((BlockHitResult)target, player, world);
            } else if (target.getType() == HitResult.Type.ENTITY) {
                this.executeInner(RayTraceUtils.getBlockResultFromEntityResult((EntityHitResult)target), player, world);
            }
        }
    }

    protected void executeInner(BlockHitResult blockTarget, Player player, Level world) {
        int shift;
        for (int offset = shift = this.canPlaceBlockState(player, world, targetPos = blockTarget.getBlockPos()) ? 0 : 1; offset < this.count + shift; ++offset) {
            BlockPos targetPos;
            this.placeBlockState(world, targetPos.relative(blockTarget.getDirection(), offset));
        }
    }

    protected boolean canPlaceBlockState(Player player, Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        boolean isSolid = state.isSolid();
        boolean isReplaceable = state.canBeReplaced();
        return world.mayInteract(player, pos) && !Services.EVENTS.onBlockPlace((Entity)player, world, pos, Direction.UP) && world.isEmptyBlock(pos) || !isSolid || isReplaceable;
    }

    protected void placeBlockState(Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        FluidState fluidState = world.getFluidState(pos);
        boolean isSolid = state.isSolid();
        boolean isReplaceable = state.canBeReplaced();
        if (world.isEmptyBlock(pos) || !isSolid || isReplaceable) {
            if (!(world.isClientSide || isSolid && !isReplaceable || state.liquid())) {
                world.destroyBlock(pos, true);
            }
            BlockState newState = this.targetStateSupplier.get();
            if (state.hasProperty((Property)BlockStateProperties.FACING) && newState.hasProperty((Property)BlockStateProperties.FACING)) {
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.FACING, (Comparable)((Direction)state.getValue((Property)BlockStateProperties.FACING)));
            } else if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) && newState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
            }
            if (fluidState.isSourceOfType((Fluid)Fluids.WATER) && newState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.TRUE);
            }
            world.setBlock(pos, newState, 3);
        }
    }
}

