/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.mods;

import com.mojang.serialization.MapCodec;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ResearchRequirement;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.SpellPropertiesPM;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import com.verdantartifice.primalmagick.common.spells.SpellPropertyConfiguration;
import com.verdantartifice.primalmagick.common.spells.mods.AbstractSpellMod;
import com.verdantartifice.primalmagick.common.spells.mods.SpellModType;
import com.verdantartifice.primalmagick.common.spells.mods.SpellModsPM;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class MineSpellMod
extends AbstractSpellMod<MineSpellMod> {
    public static final MineSpellMod INSTANCE = new MineSpellMod();
    public static final MapCodec<MineSpellMod> CODEC = MapCodec.unit((Object)INSTANCE);
    public static final StreamCodec<ByteBuf, MineSpellMod> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);
    public static final String TYPE = "mine";
    protected static final AbstractRequirement<?> REQUIREMENT = new ResearchRequirement(new ResearchEntryKey(ResearchEntries.SPELL_MOD_MINE));
    protected static final Supplier<List<SpellProperty>> PROPERTIES = () -> Arrays.asList(SpellPropertiesPM.NON_ZERO_DURATION.get());

    public static AbstractRequirement<?> getRequirement() {
        return REQUIREMENT;
    }

    public static MineSpellMod getInstance() {
        return INSTANCE;
    }

    @Override
    public SpellModType<MineSpellMod> getType() {
        return SpellModsPM.MINE.get();
    }

    @Override
    protected List<SpellProperty> getPropertiesInner() {
        return PROPERTIES.get();
    }

    @Override
    public int getBaseManaCostModifier(SpellPropertyConfiguration properties) {
        return properties.get(SpellPropertiesPM.NON_ZERO_DURATION.get());
    }

    @Override
    public int getManaCostMultiplier(SpellPropertyConfiguration properties) {
        return 1;
    }

    @Override
    protected String getModType() {
        return TYPE;
    }

    public int getDurationMinutes(SpellPackage spell, ItemStack spellSource) {
        int duration = spell.getMod(SpellModsPM.MINE.get()).orElseThrow().getPropertyValue(SpellPropertiesPM.NON_ZERO_DURATION.get());
        return 4 * duration;
    }

    @Override
    public Component getDetailTooltip(SpellPackage spell, ItemStack spellSource, LivingEntity caster, HolderLookup.Provider registries) {
        return Component.translatable((String)("spells.primalmagick.mod." + this.getModType() + ".detail_tooltip"), (Object[])new Object[]{this.getDurationMinutes(spell, spellSource)});
    }
}

