/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.mods;

import com.mojang.serialization.MapCodec;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ResearchRequirement;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.SpellPropertiesPM;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import com.verdantartifice.primalmagick.common.spells.SpellPropertyConfiguration;
import com.verdantartifice.primalmagick.common.spells.mods.AbstractSpellMod;
import com.verdantartifice.primalmagick.common.spells.mods.SpellModType;
import com.verdantartifice.primalmagick.common.spells.mods.SpellModsPM;
import com.verdantartifice.primalmagick.common.util.VectorUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class ForkSpellMod
extends AbstractSpellMod<ForkSpellMod> {
    public static final ForkSpellMod INSTANCE = new ForkSpellMod();
    public static final MapCodec<ForkSpellMod> CODEC = MapCodec.unit((Object)INSTANCE);
    public static final StreamCodec<ByteBuf, ForkSpellMod> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);
    public static final String TYPE = "fork";
    protected static final AbstractRequirement<?> REQUIREMENT = new ResearchRequirement(new ResearchEntryKey(ResearchEntries.SPELL_MOD_FORK));
    protected static final Supplier<List<SpellProperty>> PROPERTIES = () -> Arrays.asList(SpellPropertiesPM.FORKS.get(), SpellPropertiesPM.PRECISION.get());

    public static AbstractRequirement<?> getRequirement() {
        return REQUIREMENT;
    }

    public static ForkSpellMod getInstance() {
        return INSTANCE;
    }

    @Override
    public SpellModType<ForkSpellMod> getType() {
        return SpellModsPM.FORK.get();
    }

    @Override
    protected List<SpellProperty> getPropertiesInner() {
        return PROPERTIES.get();
    }

    @Override
    public int getBaseManaCostModifier(SpellPropertyConfiguration properties) {
        return 0;
    }

    @Override
    public int getManaCostMultiplier(SpellPropertyConfiguration properties) {
        int forks = properties.get(SpellPropertiesPM.FORKS.get());
        int precision = properties.get(SpellPropertiesPM.PRECISION.get());
        return 1 + forks * forks + precision * precision;
    }

    @Override
    protected String getModType() {
        return TYPE;
    }

    @Nonnull
    public List<Vec3> getDirectionUnitVectors(@Nonnull Vec3 dir, @Nonnull RandomSource rng, @Nonnull SpellPackage spell, @Nonnull ItemStack spellSource) {
        ArrayList<Vec3> retVal = new ArrayList<Vec3>();
        Vec3 normDir = dir.normalize();
        int forks = this.getForkCount(spell, spellSource);
        int degrees = this.getSpreadDegrees(spell, spellSource);
        double offsetMagnitude = Math.tan(Math.toRadians(degrees));
        for (int index = 0; index < forks; ++index) {
            Vec3 offset = VectorUtils.getRandomOrthogonalUnitVector(normDir, rng).scale(offsetMagnitude * rng.nextDouble());
            retVal.add(normDir.add(offset));
        }
        return retVal;
    }

    protected int getForkCount(SpellPackage spell, ItemStack spellSource) {
        return spell.getMod(SpellModsPM.FORK.get()).orElseThrow().getPropertyValue(SpellPropertiesPM.FORKS.get());
    }

    protected int getSpreadDegrees(SpellPackage spell, ItemStack spellSource) {
        int precision = spell.getMod(SpellModsPM.FORK.get()).orElseThrow().getPropertyValue(SpellPropertiesPM.PRECISION.get());
        return 10 + 15 * (5 - precision);
    }

    protected String getSpreadDegreesText(SpellPackage spell, ItemStack spellSource) {
        return this.getSpreadDegrees(spell, spellSource) + "\u00b0";
    }

    @Override
    public Component getDetailTooltip(SpellPackage spell, ItemStack spellSource, LivingEntity caster, HolderLookup.Provider registries) {
        return Component.translatable((String)("spells.primalmagick.mod." + this.getModType() + ".detail_tooltip"), (Object[])new Object[]{this.getForkCount(spell, spellSource), this.getSpreadDegreesText(spell, spellSource)});
    }
}

