/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.mods;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.spells.AbstractConfiguredSpellComponent;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import com.verdantartifice.primalmagick.common.spells.SpellPropertyConfiguration;
import com.verdantartifice.primalmagick.common.spells.mods.AbstractSpellMod;
import com.verdantartifice.primalmagick.common.spells.mods.EmptySpellMod;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class ConfiguredSpellMod<T extends AbstractSpellMod<?>>
extends AbstractConfiguredSpellComponent<T> {
    public ConfiguredSpellMod(T mod) {
        super(mod);
    }

    public ConfiguredSpellMod(T mod, Map<SpellProperty, Integer> configuredProperties) {
        super(mod, configuredProperties);
    }

    public ConfiguredSpellMod(T mod, SpellPropertyConfiguration configuredProperties) {
        super(mod, configuredProperties);
    }

    public static Codec<ConfiguredSpellMod<?>> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)AbstractSpellMod.dispatchCodec().fieldOf("mod").forGetter(AbstractConfiguredSpellComponent::getComponent), (App)SpellPropertyConfiguration.CODEC.fieldOf("properties").forGetter(csc -> csc.configuredProperties)).apply((Applicative)instance, ConfiguredSpellMod::new));
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ConfiguredSpellMod<?>> streamCodec() {
        return StreamCodec.composite(AbstractSpellMod.dispatchStreamCodec(), AbstractConfiguredSpellComponent::getComponent, SpellPropertyConfiguration.STREAM_CODEC, csc -> csc.configuredProperties, ConfiguredSpellMod::new);
    }

    public int getBaseManaCostModifier() {
        return ((AbstractSpellMod)this.component).getBaseManaCostModifier(this.configuredProperties);
    }

    public int getManaCostMultiplier() {
        return ((AbstractSpellMod)this.component).getManaCostMultiplier(this.configuredProperties);
    }

    public static Builder builder(SpellPackage.Builder parent) {
        return new Builder(parent);
    }

    public static class Builder {
        protected final SpellPackage.Builder parent;
        protected AbstractSpellMod<?> mod = EmptySpellMod.INSTANCE;
        protected final Map<SpellProperty, Integer> properties = new HashMap<SpellProperty, Integer>();

        public Builder(SpellPackage.Builder parent) {
            this.parent = parent;
        }

        public Builder type(AbstractSpellMod<?> mod) {
            this.mod = mod;
            return this;
        }

        public Builder with(SpellProperty property, int value) {
            this.properties.put(property, value);
            return this;
        }

        private void validate() {
            if (this.mod == null) {
                throw new IllegalStateException("No type specified for spell mod");
            }
        }

        public ConfiguredSpellMod<?> build() {
            this.validate();
            return new ConfiguredSpellMod(this.mod, this.properties);
        }

        public SpellPackage.Builder end() {
            return this.parent;
        }
    }
}

