/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.spells.SpellPropertiesPM;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;

public class SpellPropertyConfiguration {
    public static final Codec<SpellPropertyConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.simpleMap(SpellProperty.CODEC, (Codec)Codec.INT, (Keyable)StringRepresentable.keys((StringRepresentable[])((StringRepresentable[])SpellPropertiesPM.getAll().toArray(SpellProperty[]::new)))).xmap(Object2IntOpenHashMap::new, Object2IntOpenHashMap::new).fieldOf("spellProperties").forGetter(spc -> spc.propertyValues)).apply((Applicative)instance, SpellPropertyConfiguration::new));
    public static final StreamCodec<ByteBuf, SpellPropertyConfiguration> STREAM_CODEC = ByteBufCodecs.map(Object2IntOpenHashMap::new, SpellProperty.STREAM_CODEC, (StreamCodec)ByteBufCodecs.VAR_INT).map(SpellPropertyConfiguration::new, l -> l.propertyValues);
    public static final SpellPropertyConfiguration EMPTY = new SpellPropertyConfiguration();
    protected final Object2IntOpenHashMap<SpellProperty> propertyValues;

    protected SpellPropertyConfiguration() {
        this.propertyValues = new Object2IntOpenHashMap();
    }

    protected SpellPropertyConfiguration(SpellPropertyConfiguration other) {
        this.propertyValues = new Object2IntOpenHashMap(other.propertyValues);
    }

    protected SpellPropertyConfiguration(Map<SpellProperty, Integer> values) {
        this.propertyValues = new Object2IntOpenHashMap(values);
    }

    public SpellPropertyConfiguration copy() {
        return new SpellPropertyConfiguration(this);
    }

    public int get(SpellProperty property) {
        return this.getOrDefault(property, property.min());
    }

    public int getOrDefault(SpellProperty property, int defaultValue) {
        return this.propertyValues.getOrDefault((Object)property, defaultValue);
    }

    public boolean contains(SpellProperty property) {
        return this.propertyValues.containsKey((Object)property);
    }

    public void set(SpellProperty property, int value) {
        this.propertyValues.put((Object)property, value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof SpellPropertyConfiguration)) {
            return false;
        }
        SpellPropertyConfiguration that = (SpellPropertyConfiguration)o;
        return Objects.equals(this.propertyValues, that.propertyValues);
    }

    public int hashCode() {
        return Objects.hashCode(this.propertyValues);
    }
}

