/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.spells.SpellPropertiesPM;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import com.verdantartifice.primalmagick.common.spells.mods.AbstractSpellMod;
import com.verdantartifice.primalmagick.common.spells.mods.ConfiguredSpellMod;
import com.verdantartifice.primalmagick.common.spells.mods.SpellModType;
import com.verdantartifice.primalmagick.common.spells.mods.SpellModsPM;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractSpellPayload;
import com.verdantartifice.primalmagick.common.spells.payloads.ConfiguredSpellPayload;
import com.verdantartifice.primalmagick.common.spells.vehicles.AbstractSpellVehicle;
import com.verdantartifice.primalmagick.common.spells.vehicles.ConfiguredSpellVehicle;
import com.verdantartifice.primalmagick.common.stats.ExpertiseManager;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record SpellPackage(String name, ConfiguredSpellVehicle<?> vehicle, ConfiguredSpellPayload<?> payload, Optional<ConfiguredSpellMod<?>> primaryMod, Optional<ConfiguredSpellMod<?>> secondaryMod) {
    private static final int BASE_COOLDOWN_TICKS = 30;
    private static final Logger LOGGER = LogManager.getLogger();

    public static Codec<SpellPackage> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(SpellPackage::name), (App)ConfiguredSpellVehicle.codec().fieldOf("vehicle").forGetter(SpellPackage::vehicle), (App)ConfiguredSpellPayload.codec().fieldOf("payload").forGetter(SpellPackage::payload), (App)ConfiguredSpellMod.codec().optionalFieldOf("primaryMod").forGetter(SpellPackage::primaryMod), (App)ConfiguredSpellMod.codec().optionalFieldOf("secondaryMod").forGetter(SpellPackage::secondaryMod)).apply((Applicative)instance, SpellPackage::new));
    }

    public static StreamCodec<RegistryFriendlyByteBuf, SpellPackage> streamCodec() {
        return StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, SpellPackage::name, ConfiguredSpellVehicle.streamCodec(), SpellPackage::vehicle, ConfiguredSpellPayload.streamCodec(), SpellPackage::payload, (StreamCodec)ByteBufCodecs.optional(ConfiguredSpellMod.streamCodec()), SpellPackage::primaryMod, (StreamCodec)ByteBufCodecs.optional(ConfiguredSpellMod.streamCodec()), SpellPackage::secondaryMod, SpellPackage::new);
    }

    @Nonnull
    public Component getDisplayName() {
        return Component.literal((String)this.name).withStyle(this.getRarity().color());
    }

    public boolean isValid() {
        return this.vehicle != null && ((AbstractSpellVehicle)this.vehicle.getComponent()).isActive() && this.payload != null && ((AbstractSpellPayload)this.payload.getComponent()).isActive() && this.name != null && !this.name.isEmpty();
    }

    @Nullable
    public Tag serializeNBT(HolderLookup.Provider registries) {
        return SpellPackage.codec().encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).resultOrPartial(msg -> LOGGER.error("Failed to encode spell package: {}", msg)).orElse(null);
    }

    @Nullable
    public static SpellPackage deserializeNBT(Tag nbt, HolderLookup.Provider registries) {
        return SpellPackage.codec().parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).resultOrPartial(msg -> LOGGER.error("Failed to decode spell package: {}", msg)).orElse(null);
    }

    public int getCooldownTicks() {
        MutableInt retVal = new MutableInt(30);
        this.getMod(SpellModsPM.QUICKEN.get()).ifPresent(quickenMod -> retVal.subtract(5 * quickenMod.getPropertyValue(SpellPropertiesPM.HASTE.get())));
        return Mth.clamp((int)retVal.intValue(), (int)0, (int)30);
    }

    @Nonnull
    public SourceList getManaCost() {
        if (this.payload == null) {
            return SourceList.EMPTY;
        }
        int baseManaCost = 100 * this.payload.getBaseManaCost();
        if (baseManaCost == 0) {
            return SourceList.EMPTY;
        }
        Source source = ((AbstractSpellPayload)this.payload.getComponent()).getSource();
        int baseModifier = 0;
        int multiplier = 1;
        if (this.vehicle != null) {
            baseModifier += 100 * this.vehicle.getBaseManaCostModifier();
            multiplier *= this.vehicle.getManaCostMultiplier();
        }
        if (this.primaryMod.isPresent()) {
            baseModifier += 100 * this.primaryMod.get().getBaseManaCostModifier();
            multiplier *= this.primaryMod.get().getManaCostMultiplier();
        }
        if (this.secondaryMod.isPresent()) {
            baseModifier += 100 * this.secondaryMod.get().getBaseManaCostModifier();
            multiplier *= this.secondaryMod.get().getManaCostMultiplier();
        }
        return SourceList.EMPTY.add(source, (baseManaCost + baseModifier) * multiplier);
    }

    public void cast(@Nonnull Level world, @Nonnull LivingEntity caster, @Nullable ItemStack spellSource) {
        ItemStack sourceStack;
        ItemStack itemStack = sourceStack = spellSource == null ? ItemStack.EMPTY : spellSource.copy();
        if (this.payload != null) {
            ((AbstractSpellPayload)this.payload.getComponent()).playSounds(world, caster.blockPosition());
        }
        if (this.vehicle != null) {
            if (caster instanceof Player) {
                Player player = (Player)caster;
                ExpertiseManager.awardExpertise(player, this);
                StatsManager.incrementValue(player, StatsPM.SPELLS_CAST);
            }
            ((AbstractSpellVehicle)this.vehicle.getComponent()).execute(this, world, caster, sourceStack);
        }
    }

    public int getActiveModCount() {
        MutableInt retVal = new MutableInt(0);
        this.primaryMod.filter(mod -> ((AbstractSpellMod)mod.getComponent()).isActive()).ifPresent($ -> retVal.increment());
        this.secondaryMod.filter(mod -> ((AbstractSpellMod)mod.getComponent()).isActive()).ifPresent($ -> retVal.increment());
        return retVal.intValue();
    }

    @Nonnull
    public Rarity getRarity() {
        return switch (this.getActiveModCount()) {
            case 2 -> Rarity.EPIC;
            case 1 -> Rarity.RARE;
            default -> Rarity.UNCOMMON;
        };
    }

    public <T extends AbstractSpellMod<T>> Optional<ConfiguredSpellMod<T>> getMod(SpellModType<T> type) {
        ConfiguredSpellMod<?> secondary;
        ConfiguredSpellMod<?> primary = this.primaryMod.isPresent() && ((AbstractSpellMod)this.primaryMod.get().getComponent()).getType().equals(type) ? this.primaryMod.get() : null;
        ConfiguredSpellMod<?> configuredSpellMod = secondary = this.secondaryMod.isPresent() && ((AbstractSpellMod)this.secondaryMod.get().getComponent()).getType().equals(type) ? this.secondaryMod.get() : null;
        if (primary != null && secondary != null) {
            SpellProperty tiebreaker = ((AbstractSpellMod)primary.getComponent()).getType().tiebreaker().get();
            return secondary.getPropertyValue(tiebreaker) > primary.getPropertyValue(tiebreaker) ? Optional.of(secondary) : Optional.of(primary);
        }
        if (primary != null) {
            return Optional.of(primary);
        }
        return Optional.ofNullable(secondary);
    }

    @Nullable
    public ResourceLocation getIcon() {
        if (this.payload != null) {
            return ((AbstractSpellPayload)this.payload.getComponent()).getSource().getImage();
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected String name = "";
        protected ConfiguredSpellVehicle.Builder vehicleBuilder = null;
        protected ConfiguredSpellPayload.Builder payloadBuilder = null;
        protected Optional<ConfiguredSpellMod.Builder> primaryModBuilder = Optional.empty();
        protected Optional<ConfiguredSpellMod.Builder> secondaryModBuilder = Optional.empty();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public ConfiguredSpellVehicle.Builder vehicle() {
            this.vehicleBuilder = new ConfiguredSpellVehicle.Builder(this);
            return this.vehicleBuilder;
        }

        public ConfiguredSpellPayload.Builder payload() {
            this.payloadBuilder = new ConfiguredSpellPayload.Builder(this);
            return this.payloadBuilder;
        }

        public ConfiguredSpellMod.Builder primaryMod() {
            ConfiguredSpellMod.Builder retVal = new ConfiguredSpellMod.Builder(this);
            this.primaryModBuilder = Optional.of(retVal);
            return retVal;
        }

        public ConfiguredSpellMod.Builder secondaryMod() {
            ConfiguredSpellMod.Builder retVal = new ConfiguredSpellMod.Builder(this);
            this.secondaryModBuilder = Optional.of(retVal);
            return retVal;
        }

        private void validate() {
            if (this.name == null) {
                throw new IllegalStateException("No name for spell package");
            }
            if (this.vehicleBuilder == null) {
                throw new IllegalStateException("No vehicle for spell package " + this.name);
            }
            if (this.payloadBuilder == null) {
                throw new IllegalStateException("No payload for spell package " + this.name);
            }
        }

        public SpellPackage build() {
            this.validate();
            return new SpellPackage(this.name, this.vehicleBuilder.build(), this.payloadBuilder.build(), this.primaryModBuilder.map(ConfiguredSpellMod.Builder::build), this.secondaryModBuilder.map(ConfiguredSpellMod.Builder::build));
        }
    }
}

