/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells;

import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerCooldowns;
import com.verdantartifice.primalmagick.common.entities.projectiles.SpellMineEntity;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.wands.AbstractWandItem;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.SpellImpactPacket;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.spells.ISpellComponentType;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.SpellPropertiesPM;
import com.verdantartifice.primalmagick.common.spells.mods.AbstractSpellMod;
import com.verdantartifice.primalmagick.common.spells.mods.BurstSpellMod;
import com.verdantartifice.primalmagick.common.spells.mods.ConfiguredSpellMod;
import com.verdantartifice.primalmagick.common.spells.mods.MineSpellMod;
import com.verdantartifice.primalmagick.common.spells.mods.SpellModType;
import com.verdantartifice.primalmagick.common.spells.mods.SpellModsPM;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractSpellPayload;
import com.verdantartifice.primalmagick.common.spells.payloads.ConfiguredSpellPayload;
import com.verdantartifice.primalmagick.common.spells.payloads.SpellPayloadType;
import com.verdantartifice.primalmagick.common.spells.vehicles.AbstractSpellVehicle;
import com.verdantartifice.primalmagick.common.spells.vehicles.ConfiguredSpellVehicle;
import com.verdantartifice.primalmagick.common.spells.vehicles.SpellVehicleType;
import com.verdantartifice.primalmagick.common.tags.EntityTypeTagsPM;
import com.verdantartifice.primalmagick.common.wands.ISpellContainer;
import com.verdantartifice.primalmagick.common.wands.IWand;
import com.verdantartifice.primalmagick.platform.Services;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SpellManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected static final DecimalFormat COOLDOWN_FORMATTER = new DecimalFormat("#######.##");

    protected static <T extends ISpellComponentType> List<T> getFilteredTypes(@Nullable Player player, Collection<T> values) {
        return values.stream().filter(type -> type.requirementSupplier().get() == null || type.requirementSupplier().get().isMetBy(player)).sorted(Comparator.comparing(ISpellComponentType::sortOrder)).toList();
    }

    @NotNull
    public static List<SpellVehicleType<?>> getVehicleTypes(@Nullable Player player) {
        return SpellManager.getFilteredTypes(player, Services.SPELL_VEHICLE_TYPES_REGISTRY.getAll());
    }

    @NotNull
    public static List<SpellPayloadType<?>> getPayloadTypes(@Nullable Player player) {
        return SpellManager.getFilteredTypes(player, Services.SPELL_PAYLOAD_TYPES_REGISTRY.getAll());
    }

    @NotNull
    public static List<SpellModType<?>> getModTypes(@Nullable Player player) {
        return SpellManager.getFilteredTypes(player, Services.SPELL_MOD_TYPES_REGISTRY.getAll());
    }

    public static boolean isOnCooldown(@Nullable Player player) {
        return Services.CAPABILITIES.cooldowns(player).map(c -> c.isOnCooldown(IPlayerCooldowns.CooldownType.SPELL)).orElse(false);
    }

    public static void setCooldown(@Nullable Player player, int durationTicks) {
        if (player != null) {
            Services.CAPABILITIES.cooldowns(player).ifPresent(c -> {
                c.setCooldown(IPlayerCooldowns.CooldownType.SPELL, durationTicks);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    c.sync(serverPlayer);
                }
            });
            player.getCooldowns().addCooldown((Item)ItemsPM.SPELL_SCROLL_FILLED.get(), durationTicks);
            player.getCooldowns().addCooldown((Item)ItemsPM.MUNDANE_WAND.get(), durationTicks);
            player.getCooldowns().addCooldown((Item)ItemsPM.MODULAR_WAND.get(), durationTicks);
            player.getCooldowns().addCooldown((Item)ItemsPM.MODULAR_STAFF.get(), durationTicks);
        }
    }

    public static void appendSpellListingText(@Nullable Player pPlayer, ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents) {
        Item item = pStack.getItem();
        if (item instanceof ISpellContainer) {
            ISpellContainer spellContainer = (ISpellContainer)item;
            List<SpellPackage> spells = spellContainer.getSpells(pStack);
            int activeIndex = spellContainer.getActiveSpellIndex(pStack);
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.primalmagick.spells.wand_header", (Object[])new Object[]{spellContainer.getSpellCapacityText(pStack)}));
            if (spells.isEmpty()) {
                pTooltipComponents.add((Component)Component.translatable((String)"tooltip.primalmagick.spells.none"));
            } else {
                for (int index = 0; index < spells.size(); ++index) {
                    SpellPackage spell = spells.get(index);
                    if (index == activeIndex) {
                        pTooltipComponents.add((Component)Component.translatable((String)"tooltip.primalmagick.spells.name_selected", (Object[])new Object[]{spell.getDisplayName()}));
                        pTooltipComponents.addAll(SpellManager.getSpellPackageDetailTooltip(spell, pStack, pPlayer, true, pContext.registries()));
                        continue;
                    }
                    pTooltipComponents.add((Component)Component.translatable((String)"tooltip.primalmagick.spells.name_unselected", (Object[])new Object[]{spell.getDisplayName()}));
                }
            }
        }
    }

    public static void appendActiveSpellText(ItemStack pStack, List<Component> pTooltipComponents) {
        Item item = pStack.getItem();
        if (item instanceof ISpellContainer) {
            ISpellContainer spellContainer = (ISpellContainer)item;
            SpellPackage activeSpell = spellContainer.getActiveSpell(pStack);
            MutableComponent activeSpellName = activeSpell == null ? Component.translatable((String)"tooltip.primalmagick.none") : activeSpell.getDisplayName();
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.primalmagick.spells.short_wand_header", (Object[])new Object[]{activeSpellName}));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<SpellPackage> getSpells(@NotNull ItemStack mainHandStack, @NotNull ItemStack offHandStack) {
        Item item;
        ImmutableList.Builder builder = ImmutableList.builder();
        Item item2 = mainHandStack.getItem();
        if (item2 instanceof IWand) {
            IWand mainHandWand = (IWand)item2;
            if (offHandStack.getItem() instanceof IWand) {
                builder.addAll(mainHandWand.getSpells(mainHandStack));
                return builder.build();
            }
        }
        if ((item = mainHandStack.getItem()) instanceof ISpellContainer) {
            ISpellContainer mainHandContainer = (ISpellContainer)item;
            builder.addAll(mainHandContainer.getSpells(mainHandStack));
        }
        if (!((item = offHandStack.getItem()) instanceof ISpellContainer)) return builder.build();
        ISpellContainer offHandContainer = (ISpellContainer)item;
        builder.addAll(offHandContainer.getSpells(offHandStack));
        return builder.build();
    }

    public static int getSpellCount(@NotNull ItemStack mainHandStack, @NotNull ItemStack offHandStack) {
        return SpellManager.getSpells(mainHandStack, offHandStack).size();
    }

    public static int getActiveSpellIndex(@NotNull ItemStack mainHandStack, @NotNull ItemStack offHandStack) {
        ISpellContainer offHandContainer;
        int offHandSelection;
        ISpellContainer mainHandContainer;
        int mainHandSelection2;
        Item item = mainHandStack.getItem();
        if (item instanceof ISpellContainer && (mainHandSelection2 = (mainHandContainer = (ISpellContainer)item).getActiveSpellIndex(mainHandStack)) != -2) {
            return mainHandSelection2;
        }
        Item mainHandSelection2 = offHandStack.getItem();
        if (mainHandSelection2 instanceof ISpellContainer && (offHandSelection = (offHandContainer = (ISpellContainer)mainHandSelection2).getActiveSpellIndex(offHandStack)) != -2) {
            int n;
            Item item2 = mainHandStack.getItem();
            if (item2 instanceof ISpellContainer) {
                ISpellContainer mainHandContainer2 = (ISpellContainer)item2;
                n = mainHandContainer2.getSpellCount(mainHandStack);
            } else {
                n = 0;
            }
            int padding = n;
            return offHandSelection + padding;
        }
        return -1;
    }

    @Nullable
    public static SpellPackage getActiveSpell(@NotNull ItemStack mainHandStack, @NotNull ItemStack offHandStack) {
        ISpellContainer mainHandContainer;
        SpellPackage activeSpell;
        Item item = mainHandStack.getItem();
        if (item instanceof ISpellContainer && (activeSpell = (mainHandContainer = (ISpellContainer)item).getActiveSpell(mainHandStack)) != null) {
            return activeSpell;
        }
        item = offHandStack.getItem();
        if (item instanceof ISpellContainer) {
            ISpellContainer offHandContainer = (ISpellContainer)item;
            return offHandContainer.getActiveSpell(offHandStack);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean setActiveSpellIndex(@Nullable Player player, @NotNull ItemStack mainHandStack, @NotNull ItemStack offHandStack, int index) {
        block15: {
            block14: {
                retVal = false;
                var9_5 = mainHandStack.getItem();
                if (!(var9_5 instanceof ISpellContainer)) break block14;
                mainHandContainer = (ISpellContainer)var9_5;
                var9_5 = offHandStack.getItem();
                if (!(var9_5 instanceof ISpellContainer)) break block14;
                offHandContainer = (ISpellContainer)var9_5;
                mainHandCount = mainHandContainer.getSpellCount(mainHandStack);
                if (index == -1) {
                    mainHandContainer.setActiveSpellIndex(mainHandStack, index);
                    offHandContainer.setActiveSpellIndex(offHandStack, index);
                    retVal = true;
                } else if (index >= 0 && index < mainHandCount) {
                    mainHandContainer.setActiveSpellIndex(mainHandStack, index);
                    offHandContainer.setActiveSpellIndex(offHandStack, -2);
                    retVal = true;
                } else if (index >= mainHandCount && index < mainHandCount + offHandContainer.getSpellCount(offHandStack)) {
                    mainHandContainer.setActiveSpellIndex(mainHandStack, -2);
                    offHandContainer.setActiveSpellIndex(offHandStack, index - mainHandCount);
                    retVal = true;
                }
                break block15;
            }
            if (!((var9_5 = mainHandStack.getItem()) instanceof ISpellContainer)) ** GOTO lbl-1000
            mainHandContainer = (ISpellContainer)var9_5;
            if (index == -1 || index >= 0 && index < mainHandContainer.getSpellCount(mainHandStack)) {
                mainHandContainer.setActiveSpellIndex(mainHandStack, index);
                retVal = true;
            } else if ((var9_5 = offHandStack.getItem()) instanceof ISpellContainer) {
                offHandContainer = (ISpellContainer)var9_5;
                if (index == -1 || index >= 0 && index < offHandContainer.getSpellCount(offHandStack)) {
                    offHandContainer.setActiveSpellIndex(offHandStack, index);
                    retVal = true;
                }
            }
        }
        if (retVal && player != null) {
            spell = SpellManager.getActiveSpell(mainHandStack, offHandStack);
            if (spell == null) {
                player.sendSystemMessage((Component)Component.translatable((String)"event.primalmagick.cycle_spell.none"));
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"event.primalmagick.cycle_spell", (Object[])new Object[]{spell.getDisplayName()}));
            }
        } else if (!retVal) {
            SpellManager.LOGGER.warn("Failed to set active spell to invalid index {}", (Object)index);
        }
        return retVal;
    }

    public static void executeSpellPayload(@NotNull SpellPackage spell, @NotNull HitResult result, @NotNull Level world, @NotNull LivingEntity caster, @Nullable ItemStack spellSource, boolean allowMine, @Nullable Entity projectileEntity) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            if (spell.payload() != null) {
                Vec3 hitVec = result.getLocation();
                ConfiguredSpellMod burstMod = spell.getMod(SpellModsPM.BURST.get()).orElse(null);
                ConfiguredSpellMod mineMod = spell.getMod(SpellModsPM.MINE.get()).orElse(null);
                int radius = burstMod == null || allowMine && mineMod != null ? 1 : burstMod.getPropertyValue(SpellPropertiesPM.RADIUS.get());
                PacketHandler.sendToAllAround(new SpellImpactPacket(hitVec.x, hitVec.y, hitVec.z, radius, ((AbstractSpellPayload)spell.payload().getComponent()).getSource().getColor()), serverLevel, BlockPos.containing((Position)hitVec), 64.0);
                if (allowMine && mineMod != null) {
                    SpellMineEntity mineEntity = new SpellMineEntity(world, hitVec, caster, spell, spellSource, ((MineSpellMod)mineMod.getComponent()).getDurationMinutes(spell, spellSource));
                    world.addFreshEntity((Entity)mineEntity);
                } else if (burstMod != null) {
                    Set<HitResult> targetSet = ((BurstSpellMod)burstMod.getComponent()).getBurstTargets(result, spell, spellSource, caster, world);
                    for (HitResult target : targetSet) {
                        ((AbstractSpellPayload)spell.payload().getComponent()).execute(target, hitVec, spell, world, caster, spellSource, null);
                    }
                } else {
                    ((AbstractSpellPayload)spell.payload().getComponent()).execute(result, null, spell, world, caster, spellSource, null);
                }
            }
        }
    }

    public static boolean canPolymorph(@NotNull EntityType<?> entityType) {
        if (entityType.is(EntityTypeTagsPM.POLYMORPH_ALLOW)) {
            return true;
        }
        if (entityType.is(EntityTypeTagsPM.POLYMORPH_BAN)) {
            return false;
        }
        return !entityType.getCategory().equals((Object)MobCategory.MISC);
    }

    @NotNull
    public static List<Component> getSpellPackageDetailTooltip(@Nullable SpellPackage spell, @NotNull ItemStack spellSource, @Nullable Player player, boolean indent, HolderLookup.Provider registries) {
        MutableComponent leader;
        ArrayList<Component> retVal = new ArrayList<Component>();
        MutableComponent mutableComponent = leader = indent ? Component.literal((String)"    ") : Component.literal((String)"");
        if (spell != null) {
            ConfiguredSpellPayload<?> payload;
            ConfiguredSpellVehicle<?> vehicle = spell.vehicle();
            if (vehicle != null) {
                retVal.add((Component)leader.copy().append((Component)Component.translatable((String)"tooltip.primalmagick.spells.details.vehicle", (Object[])new Object[]{((AbstractSpellVehicle)vehicle.getComponent()).getDetailTooltip(spell, spellSource, null, registries)})));
            }
            if ((payload = spell.payload()) != null) {
                retVal.add((Component)leader.copy().append((Component)Component.translatable((String)"tooltip.primalmagick.spells.details.payload", (Object[])new Object[]{((AbstractSpellPayload)payload.getComponent()).getDetailTooltip(spell, spellSource, null, registries)})));
            }
            Optional<ConfiguredSpellMod<?>> primary = spell.primaryMod();
            Optional<ConfiguredSpellMod<?>> secondary = spell.secondaryMod();
            if (primary.isPresent() && ((AbstractSpellMod)primary.get().getComponent()).isActive() && secondary.isPresent() && ((AbstractSpellMod)secondary.get().getComponent()).isActive()) {
                retVal.add((Component)leader.copy().append((Component)Component.translatable((String)"tooltip.primalmagick.spells.details.mods.double", (Object[])new Object[]{((AbstractSpellMod)primary.get().getComponent()).getDetailTooltip(spell, spellSource, null, registries), ((AbstractSpellMod)secondary.get().getComponent()).getDetailTooltip(spell, spellSource, null, registries)})));
            } else if (primary.isPresent() && ((AbstractSpellMod)primary.get().getComponent()).isActive()) {
                retVal.add((Component)leader.copy().append((Component)Component.translatable((String)"tooltip.primalmagick.spells.details.mods.single", (Object[])new Object[]{((AbstractSpellMod)primary.get().getComponent()).getDetailTooltip(spell, spellSource, null, registries)})));
            } else if (secondary.isPresent() && ((AbstractSpellMod)secondary.get().getComponent()).isActive()) {
                retVal.add((Component)leader.copy().append((Component)Component.translatable((String)"tooltip.primalmagick.spells.details.mods.single", (Object[])new Object[]{((AbstractSpellMod)secondary.get().getComponent()).getDetailTooltip(spell, spellSource, null, registries)})));
            }
            retVal.add((Component)leader.copy().append((Component)Component.translatable((String)"tooltip.primalmagick.spells.details.cooldown", (Object[])new Object[]{COOLDOWN_FORMATTER.format((double)spell.getCooldownTicks() / 20.0)})));
            Item item = spellSource.getItem();
            if (item instanceof AbstractWandItem) {
                AbstractWandItem wandItem = (AbstractWandItem)item;
                if (player != null && payload != null) {
                    Source source = ((AbstractSpellPayload)payload.getComponent()).getSource();
                    SourceList baseCost = spell.getManaCost();
                    SourceList modifiedCost = wandItem.getModifiedCost(spellSource, player, baseCost, registries);
                    retVal.add((Component)leader.copy().append((Component)Component.translatable((String)"tooltip.primalmagick.spells.details.mana_cost", (Object[])new Object[]{modifiedCost.getScaledText(0.01)})));
                }
            }
        }
        return retVal;
    }
}

