/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells;

import com.verdantartifice.primalmagick.common.spells.ISpellComponent;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import com.verdantartifice.primalmagick.common.spells.SpellPropertyConfiguration;
import java.util.Map;
import java.util.Objects;
import net.minecraft.util.Mth;

public abstract class AbstractConfiguredSpellComponent<T extends ISpellComponent> {
    protected final T component;
    protected final SpellPropertyConfiguration configuredProperties;

    protected AbstractConfiguredSpellComponent(T component) {
        this.component = component;
        this.configuredProperties = SpellPropertyConfiguration.EMPTY.copy();
    }

    protected AbstractConfiguredSpellComponent(T component, Map<SpellProperty, Integer> configuredProperties) {
        this.component = component;
        this.configuredProperties = new SpellPropertyConfiguration(configuredProperties);
    }

    protected AbstractConfiguredSpellComponent(T component, SpellPropertyConfiguration configuredProperties) {
        this.component = component;
        this.configuredProperties = new SpellPropertyConfiguration(configuredProperties);
    }

    public T getComponent() {
        return this.component;
    }

    public int getPropertyValue(SpellProperty property) {
        return this.configuredProperties.getOrDefault(property, property.min());
    }

    public void setPropertyValue(SpellProperty property, int value) {
        if (this.component.getProperties().contains(property)) {
            this.configuredProperties.set(property, Mth.clamp((int)value, (int)property.min(), (int)property.max()));
        }
    }

    public boolean isFullyConfigured() {
        return this.component != null && this.component.getProperties().stream().allMatch(prop -> this.configuredProperties.contains((SpellProperty)prop));
    }

    public boolean equals(Object o) {
        if (!(o instanceof AbstractConfiguredSpellComponent)) {
            return false;
        }
        AbstractConfiguredSpellComponent that = (AbstractConfiguredSpellComponent)o;
        return Objects.equals(this.component, that.component) && Objects.equals(this.configuredProperties, that.configuredProperties);
    }

    public int hashCode() {
        return Objects.hash(this.component, this.configuredProperties);
    }
}

