/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.sources;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.Sources;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;

@Immutable
public class SourceList {
    public static final Codec<SourceList> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.simpleMap(Source.CODEC, (Codec)Codec.INT, (Keyable)StringRepresentable.keys((StringRepresentable[])((StringRepresentable[])Sources.getAllSorted().toArray(Source[]::new)))).xmap(Object2IntOpenHashMap::new, Object2IntOpenHashMap::new).fieldOf("sources").forGetter(sl -> sl.sources)).apply((Applicative)instance, SourceList::new));
    public static final StreamCodec<ByteBuf, SourceList> STREAM_CODEC = ByteBufCodecs.map(Object2IntOpenHashMap::new, Source.STREAM_CODEC, (StreamCodec)ByteBufCodecs.VAR_INT).map(SourceList::new, l -> l.sources);
    protected static final DecimalFormat FORMATTER = new DecimalFormat("#######.##");
    public static final SourceList EMPTY = new SourceList();
    protected final Object2IntOpenHashMap<Source> sources;

    protected SourceList() {
        this.sources = new Object2IntOpenHashMap();
    }

    protected SourceList(SourceList other) {
        this.sources = new Object2IntOpenHashMap(other.sources);
    }

    protected SourceList(Map<Source, Integer> values) {
        this();
        values.entrySet().forEach(entry -> this.setInner((Source)entry.getKey(), (Integer)entry.getValue()));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static SourceList fromNetwork(@Nonnull FriendlyByteBuf buf) {
        Builder retVal = SourceList.builder();
        for (Source source : Sources.getAllSorted()) {
            retVal.with(source, buf.readVarInt());
        }
        return retVal.build();
    }

    public static void toNetwork(@Nonnull FriendlyByteBuf buf, @Nonnull SourceList sources) {
        Sources.getAllSorted().stream().map(sources::getAmount).forEach(arg_0 -> ((FriendlyByteBuf)buf).writeVarInt(arg_0));
    }

    public int getAmount(@Nullable Source source) {
        return this.sources.getOrDefault((Object)source, 0);
    }

    @Nonnull
    public SourceList add(@Nullable Source source, int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Amount may not be negative");
        }
        if (source != null && amount > 0) {
            SourceList retVal = new SourceList(this);
            retVal.addInner(source, amount);
            return retVal;
        }
        return this;
    }

    @Nonnull
    public SourceList add(@Nullable SourceList list) {
        if (list != null && !list.isEmpty()) {
            SourceList retVal = new SourceList(this);
            for (Source source : list.getSources()) {
                retVal.addInner(source, list.getAmount(source));
            }
            return retVal;
        }
        return this;
    }

    private void addInner(@Nonnull Source source, int amount) {
        this.setInner(source, this.getAmount(source) + amount);
    }

    public SourceList reduce(@Nullable Source source, int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Amount may not be negative");
        }
        if (source != null && amount > 0) {
            int newAmount = this.getAmount(source) - amount;
            if (newAmount == 0) {
                SourceList retVal = new SourceList(this);
                retVal.sources.removeInt((Object)source);
                return retVal;
            }
            if (newAmount > 0) {
                SourceList retVal = new SourceList(this);
                retVal.setInner(source, newAmount);
                return retVal;
            }
        }
        return this;
    }

    @Nonnull
    public SourceList remove(@Nullable Source source) {
        if (source != null && this.sources.containsKey((Object)source)) {
            SourceList retVal = new SourceList(this);
            retVal.sources.removeInt((Object)source);
            return retVal;
        }
        return this;
    }

    @Nonnull
    public SourceList remove(@Nullable Source source, int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Amount may not be non-positive");
        }
        if (source != null && amount > 0) {
            int newAmount = this.getAmount(source) - amount;
            if (newAmount <= 0) {
                return this.remove(source);
            }
            SourceList retVal = new SourceList(this);
            retVal.setInner(source, newAmount);
            return retVal;
        }
        return this;
    }

    @Nonnull
    public SourceList remove(@Nullable SourceList list) {
        if (list != null && !list.isEmpty()) {
            SourceList retVal = new SourceList(this);
            for (Source source : list.getSources()) {
                int newAmount = this.getAmount(source) - list.getAmount(source);
                if (newAmount <= 0) {
                    retVal.sources.removeInt((Object)source);
                    continue;
                }
                retVal.setInner(source, newAmount);
            }
            return retVal;
        }
        return this;
    }

    @Nonnull
    public SourceList merge(@Nullable Source source, int amount) {
        if (source != null && amount > this.getAmount(source)) {
            SourceList retVal = new SourceList(this);
            retVal.setInner(source, amount);
            return retVal;
        }
        return this;
    }

    @Nonnull
    public SourceList merge(@Nullable SourceList list) {
        if (list != null && !list.isEmpty()) {
            SourceList retVal = new SourceList(this);
            for (Source source : list.getSources()) {
                retVal.setInner(source, Math.max(this.getAmount(source), list.getAmount(source)));
            }
            return retVal;
        }
        return this;
    }

    @Nonnull
    public SourceList set(@Nullable Source source, int amount) {
        if (source != null) {
            SourceList retVal = new SourceList(this);
            retVal.setInner(source, amount);
            return retVal;
        }
        return this;
    }

    @Nonnull
    public SourceList set(@Nullable SourceList list) {
        if (list != null && !list.isEmpty()) {
            SourceList retVal = new SourceList(this);
            for (Source source : list.getSources()) {
                retVal.setInner(source, list.getAmount(source));
            }
            return retVal;
        }
        return this;
    }

    private void setInner(@Nonnull Source source, int amount) {
        if (amount == 0) {
            this.sources.removeInt((Object)source);
        } else {
            this.sources.put((Object)source, amount);
        }
    }

    @Nonnull
    public SourceList multiply(double multiplier) {
        if (multiplier == 0.0) {
            return EMPTY;
        }
        if (multiplier == 1.0) {
            return this;
        }
        if (multiplier > 0.0) {
            SourceList retVal = new SourceList(this);
            for (Source source : this.getSources()) {
                retVal.setInner(source, Mth.floor((double)(multiplier * (double)this.getAmount(source))));
            }
            return retVal;
        }
        throw new IllegalArgumentException("Multiplier may not be negative");
    }

    @Nonnull
    public Set<Source> getSources() {
        return Collections.unmodifiableSet(this.sources.keySet());
    }

    @Nonnull
    public List<Source> getSourcesSorted() {
        return Sources.getAllSorted().stream().filter(this::isPresent).toList();
    }

    public int getSize() {
        return this.sources.size();
    }

    public int getManaSize() {
        return this.sources.values().intStream().sum();
    }

    public boolean isEmpty() {
        return this.sources.isEmpty();
    }

    public boolean isPresent(Source source) {
        return this.getAmount(source) > 0;
    }

    @Nonnull
    public SourceList copy() {
        return new SourceList(this);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag tagList = new ListTag();
        for (Source source : this.getSources()) {
            if (source == null) continue;
            CompoundTag singleTag = new CompoundTag();
            singleTag.putString("key", source.getId().toString());
            singleTag.putInt("amount", this.getAmount(source));
            tagList.add((Object)singleTag);
        }
        tag.put("Sources", (Tag)tagList);
        return tag;
    }

    public static SourceList deserializeNBT(CompoundTag nbt) {
        Builder retVal = SourceList.builder();
        ListTag tagList = nbt.getList("Sources", 10);
        for (int index = 0; index < tagList.size(); ++index) {
            CompoundTag singleTag = tagList.getCompound(index);
            if (!singleTag.contains("key")) continue;
            retVal.with(Sources.get(ResourceLocation.parse((String)singleTag.getString("key"))), singleTag.getInt("amount"));
        }
        return retVal.build();
    }

    @Nonnull
    public JsonObject serializeJson() {
        JsonObject json = new JsonObject();
        for (Source source : Sources.getAllSorted()) {
            int value = this.getAmount(source);
            if (value <= 0) continue;
            json.addProperty(source.getId().toString(), (Number)value);
        }
        return json;
    }

    public Component getText() {
        return this.getScaledText(1.0);
    }

    public Component getScaledText(double multiplier) {
        List<Source> contents = this.getSourcesSorted();
        MutableComponent output = Component.literal((String)"");
        for (int index = 0; index < contents.size(); ++index) {
            Source source = contents.get(index);
            if (index != 0) {
                output = output.append((Component)Component.literal((String)", "));
            }
            output = output.append((Component)Component.translatable((String)"tooltip.primalmagick.spells.details.mana_cost.piece", (Object[])new Object[]{FORMATTER.format((double)this.getAmount(source) * multiplier), source.getNameText()}));
        }
        return output;
    }

    public String toString() {
        List<String> pieces = Sources.getAllSorted().stream().filter(arg_0 -> this.sources.containsKey(arg_0)).map(source -> String.join((CharSequence)"=", source.getId().toString(), Integer.toString(this.sources.getInt(source)))).toList();
        return "SourceList[" + String.join((CharSequence)",", pieces) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.sources);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourceList other = (SourceList)obj;
        return Objects.equals(this.sources, other.sources);
    }

    public static class Builder {
        protected final Object2IntOpenHashMap<Source> sources = new Object2IntOpenHashMap();

        protected Builder() {
        }

        public Builder with(Source source, int amount) {
            this.sources.put((Object)source, amount);
            return this;
        }

        public Builder with(SourceList list) {
            list.getSources().stream().forEach(source -> this.sources.put(source, list.getAmount((Source)source)));
            return this;
        }

        public Builder withEarth(int amount) {
            return this.with(Sources.EARTH, amount);
        }

        public Builder withSea(int amount) {
            return this.with(Sources.SEA, amount);
        }

        public Builder withSky(int amount) {
            return this.with(Sources.SKY, amount);
        }

        public Builder withSun(int amount) {
            return this.with(Sources.SUN, amount);
        }

        public Builder withMoon(int amount) {
            return this.with(Sources.MOON, amount);
        }

        public Builder withBlood(int amount) {
            return this.with(Sources.BLOOD, amount);
        }

        public Builder withInfernal(int amount) {
            return this.with(Sources.INFERNAL, amount);
        }

        public Builder withVoid(int amount) {
            return this.with(Sources.VOID, amount);
        }

        public Builder withHallowed(int amount) {
            return this.with(Sources.HALLOWED, amount);
        }

        public SourceList build() {
            return new SourceList((Map<Source, Integer>)this.sources);
        }
    }
}

