/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.sources;

import com.mojang.serialization.Codec;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.keys.AbstractResearchKey;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.research.requirements.ResearchRequirement;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.stats.Stat;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;

public class Source
implements StringRepresentable {
    protected static final ResourceLocation UNKNOWN_IMAGE = ResourceUtils.loc("textures/research/research_unknown.png");
    protected static final ResourceLocation UNKNOWN_ATLAS_LOC = ResourceUtils.loc("research/research_unknown");
    public static final Codec<Source> CODEC = ResourceLocation.CODEC.xmap(Sources::get, Source::getId);
    public static final StreamCodec<ByteBuf, Source> STREAM_CODEC = ResourceLocation.STREAM_CODEC.map(Sources::get, Source::getId);
    protected final ResourceLocation id;
    protected final int color;
    protected final ChatFormatting chatColor;
    protected final double observationMultiplier;
    protected final Stat manaSpentStat;
    protected final Optional<ResearchEntryKey> discoverKey;
    protected final Optional<ResearchRequirement> discoverRequirement;
    protected final int sortOrder;
    protected final ResourceLocation image;
    protected final ResourceLocation atlasLoc;

    public Source(ResourceLocation id, int color, ChatFormatting chatColor, double observationMultiplier, Stat manaSpentStat, Optional<ResearchEntryKey> discoverKey, int sortOrder, ResourceLocation image, ResourceLocation atlasLoc) {
        this.id = id;
        this.color = color;
        this.chatColor = chatColor;
        this.observationMultiplier = observationMultiplier;
        this.manaSpentStat = manaSpentStat;
        this.discoverKey = discoverKey;
        this.discoverRequirement = discoverKey.map(k -> new ResearchRequirement((AbstractResearchKey<?>)k));
        this.sortOrder = sortOrder;
        this.image = image;
        this.atlasLoc = atlasLoc;
        Sources.register(this);
    }

    public Source(ResourceLocation id, int color, ChatFormatting chatColor, double observationMultiplier, Stat manaSpentStat, ResourceKey<ResearchEntry> discoverKey, int sortOrder) {
        this(id, color, chatColor, observationMultiplier, manaSpentStat, Optional.of(new ResearchEntryKey(discoverKey)), sortOrder, ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("textures/sources/" + id.getPath() + ".png")), ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("sources/" + id.getPath())));
    }

    public Source(ResourceLocation id, int color, ChatFormatting chatColor, double observationMultiplier, Stat manaSpentStat, int sortOrder) {
        this(id, color, chatColor, observationMultiplier, manaSpentStat, Optional.empty(), sortOrder, ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("textures/sources/" + id.getPath() + ".png")), ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("sources/" + id.getPath())));
    }

    @Nonnull
    public ResourceLocation getId() {
        return this.id;
    }

    @Nonnull
    public String getNameTranslationKey() {
        return Source.getNameTranslationKey(this.id);
    }

    private static String getNameTranslationKey(ResourceLocation id) {
        return String.join((CharSequence)".", "source", id.getNamespace(), id.getPath());
    }

    public int getColor() {
        return this.color;
    }

    public double getObservationMultiplier() {
        return this.observationMultiplier;
    }

    @Nonnull
    public ChatFormatting getChatColor() {
        return this.chatColor;
    }

    @Nonnull
    public Component getNameText() {
        return this.getNameText(this.getChatColor());
    }

    @Nonnull
    public Component getNameText(ChatFormatting format) {
        return Component.translatable((String)this.getNameTranslationKey()).withStyle(format);
    }

    @Nonnull
    public Stat getManaSpentStat() {
        return this.manaSpentStat;
    }

    @Nonnull
    public Optional<ResearchEntryKey> getDiscoverKey() {
        return this.discoverKey;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    @Nonnull
    public ResourceLocation getImage() {
        return this.image;
    }

    @Nonnull
    public ResourceLocation getAtlasLocation() {
        return this.atlasLoc;
    }

    public boolean isDiscovered(@Nullable Player player) {
        if (this.discoverRequirement.isEmpty()) {
            return true;
        }
        return this.discoverRequirement.get().isMetBy(player);
    }

    @Nonnull
    public static String getUnknownTranslationKey() {
        return Source.getNameTranslationKey(ResourceUtils.loc("unknown"));
    }

    @Nonnull
    public static ResourceLocation getUnknownImage() {
        return UNKNOWN_IMAGE;
    }

    @Nonnull
    public static ResourceLocation getUnknownAtlasLocation() {
        return UNKNOWN_ATLAS_LOC;
    }

    public String getSerializedName() {
        return this.getId().toString();
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Source other = (Source)obj;
        return Objects.equals(this.id, other.id);
    }
}

