/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.runes;

import com.mojang.serialization.Codec;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.research.requirements.ResearchRequirement;
import com.verdantartifice.primalmagick.common.runes.Rune;
import com.verdantartifice.primalmagick.common.runes.RuneType;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Rarity;

public class SourceRune
extends Rune {
    public static final Codec<SourceRune> CODEC = ResourceLocation.CODEC.xmap(loc -> {
        Rune patt0$temp = Rune.getRune(loc);
        if (patt0$temp instanceof SourceRune) {
            SourceRune source = (SourceRune)patt0$temp;
            return source;
        }
        throw new IllegalArgumentException("Unknown source rune: " + loc.toString());
    }, s -> s.getId());
    protected final Source source;

    public SourceRune(@Nonnull String tag, @Nonnull ResourceKey<ResearchEntry> discoveryKey, @Nonnull Source source) {
        super(ResourceUtils.loc(tag), new ResearchRequirement(new ResearchEntryKey(discoveryKey)), Rarity.COMMON, false, -1);
        this.source = source;
    }

    @Override
    public RuneType getType() {
        return RuneType.SOURCE;
    }

    public Source getSource() {
        return this.source;
    }
}

