/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.runes;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

public enum RuneType implements StringRepresentable
{
    VERB(0, "verb"),
    NOUN(1, "noun"),
    SOURCE(2, "source"),
    POWER(3, "power");

    private static final IntFunction<RuneType> BY_ID;
    public static final Codec<RuneType> CODEC;
    public static final StreamCodec<ByteBuf, RuneType> STREAM_CODEC;
    private final int id;
    private final String name;

    private RuneType(int id, String str) {
        this.id = id;
        this.name = str;
    }

    public int getId() {
        return this.id;
    }

    @Nonnull
    public String getSerializedName() {
        return this.name;
    }

    @Nullable
    public static RuneType fromName(@Nullable String name) {
        for (RuneType rune : RuneType.values()) {
            if (!rune.getSerializedName().equals(name)) continue;
            return rune;
        }
        return null;
    }

    static {
        BY_ID = ByIdMap.continuous(RuneType::getId, (Object[])RuneType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        CODEC = StringRepresentable.fromEnum(RuneType::values);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, RuneType::getId);
    }
}

