/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.runes;

import com.google.common.collect.ImmutableList;
import com.verdantartifice.primalmagick.common.components.DataComponentsPM;
import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.research.keys.RuneEnchantmentKey;
import com.verdantartifice.primalmagick.common.research.keys.RuneEnchantmentPartialKey;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.runes.NounRune;
import com.verdantartifice.primalmagick.common.runes.Rune;
import com.verdantartifice.primalmagick.common.runes.RuneEnchantmentDefinition;
import com.verdantartifice.primalmagick.common.runes.RuneType;
import com.verdantartifice.primalmagick.common.runes.SourceRune;
import com.verdantartifice.primalmagick.common.runes.VerbRune;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class RuneManager {
    public static Set<Holder<Enchantment>> getRuneEnchantments(RegistryAccess registryAccess) {
        return registryAccess.registryOrThrow(RegistryKeysPM.RUNE_ENCHANTMENT_DEFINITIONS).stream().map(RuneEnchantmentDefinition::result).collect(Collectors.toUnmodifiableSet());
    }

    public static List<Holder<Enchantment>> getRuneEnchantmentsSorted(RegistryAccess registryAccess) {
        return RuneManager.getRuneEnchantments(registryAccess).stream().sorted(Comparator.comparing(e -> Enchantment.getFullname((Holder)e, (int)1).getString())).collect(Collectors.toList());
    }

    @Nonnull
    public static Map<Holder<Enchantment>, Integer> getRuneEnchantments(RegistryAccess registryAccess, @Nullable List<Rune> runes, @Nullable ItemStack stack, @Nullable Player player, boolean filterIncompatible) {
        if (runes == null || runes.isEmpty() || stack == null || stack.isEmpty() || player == null || !RuneManager.checkLimits(runes)) {
            return Collections.emptyMap();
        }
        List<VerbRune> verbRunes = runes.stream().filter(r -> r != null && r.getType() == RuneType.VERB).map(r -> (VerbRune)r).toList();
        List<NounRune> nounRunes = runes.stream().filter(r -> r != null && r.getType() == RuneType.NOUN).map(r -> (NounRune)r).toList();
        List<SourceRune> sourceRunes = runes.stream().filter(r -> r != null && r.getType() == RuneType.SOURCE).map(r -> (SourceRune)r).toList();
        int powerLevel = 1 + (int)runes.stream().filter(r -> r != null && r.getType() == RuneType.POWER).count();
        ArrayList<EnchantmentInstance> intermediate = new ArrayList<EnchantmentInstance>();
        for (VerbRune verb : verbRunes) {
            for (NounRune noun : nounRunes) {
                for (SourceRune source : sourceRunes) {
                    HashSet<Holder<Enchantment>> possibleEnchantments = new HashSet<Holder<Enchantment>>();
                    possibleEnchantments.addAll(RuneManager.getVerbEnchantments(registryAccess, verb));
                    possibleEnchantments.retainAll(RuneManager.getNounEnchantments(registryAccess, noun));
                    possibleEnchantments.retainAll(RuneManager.getSourceEnchantments(registryAccess, source));
                    for (Holder holder : possibleEnchantments) {
                        Optional<AbstractRequirement<?>> reqOpt = RuneManager.getEnchantmentRequirement(registryAccess, (Holder<Enchantment>)holder);
                        if (!((Enchantment)holder.value()).canEnchant(stack) || !reqOpt.isEmpty() && !reqOpt.get().isMetBy(player) || powerLevel < ((Enchantment)holder.value()).getMinLevel()) continue;
                        intermediate.add(new EnchantmentInstance(holder, Math.min(powerLevel, ((Enchantment)holder.value()).getMaxLevel())));
                    }
                }
            }
        }
        intermediate.sort(Comparator.comparingInt(i -> ((Enchantment)i.enchantment.value()).getMinCost(i.level)).reversed().thenComparingInt(i -> i.hashCode()));
        HashMap<Holder<Enchantment>, Integer> retVal = new HashMap<Holder<Enchantment>, Integer>();
        intermediate.forEach(instance -> {
            if (!filterIncompatible || EnchantmentHelper.isEnchantmentCompatible(retVal.keySet(), (Holder)instance.enchantment)) {
                retVal.put(instance.enchantment, instance.level);
            }
        });
        return retVal;
    }

    private static Set<Holder<Enchantment>> getVerbEnchantments(RegistryAccess registryAccess, VerbRune verb) {
        return registryAccess.registryOrThrow(RegistryKeysPM.RUNE_ENCHANTMENT_DEFINITIONS).stream().filter(def -> def.verb().equals(verb)).map(def -> def.result()).collect(Collectors.toUnmodifiableSet());
    }

    private static Set<Holder<Enchantment>> getNounEnchantments(RegistryAccess registryAccess, NounRune noun) {
        return registryAccess.registryOrThrow(RegistryKeysPM.RUNE_ENCHANTMENT_DEFINITIONS).stream().filter(def -> def.noun().equals(noun)).map(def -> def.result()).collect(Collectors.toUnmodifiableSet());
    }

    private static Set<Holder<Enchantment>> getSourceEnchantments(RegistryAccess registryAccess, SourceRune source) {
        return registryAccess.registryOrThrow(RegistryKeysPM.RUNE_ENCHANTMENT_DEFINITIONS).stream().filter(def -> def.source().equals(source)).map(def -> def.result()).collect(Collectors.toUnmodifiableSet());
    }

    private static Optional<AbstractRequirement<?>> getEnchantmentRequirement(RegistryAccess registryAccess, Holder<Enchantment> enchant) {
        return RuneManager.getRuneDefinition(registryAccess, enchant).flatMap(def -> def.requirementOpt());
    }

    public static boolean checkLimits(@Nonnull List<Rune> runes) {
        HashMap<ResourceLocation, Integer> counts = new HashMap<ResourceLocation, Integer>();
        for (Rune rune : runes) {
            if (!rune.hasLimit()) continue;
            counts.put(rune.getId(), counts.getOrDefault(rune.getId(), 0) + 1);
            if (counts.getOrDefault(rune.getId(), 0) <= rune.getLimit()) continue;
            return false;
        }
        return true;
    }

    public static ItemEnchantments mergeEnchantments(@Nonnull ItemEnchantments original, @Nonnull Map<Holder<Enchantment>, Integer> addition) {
        ItemEnchantments.Mutable retVal = new ItemEnchantments.Mutable(original);
        for (Map.Entry<Holder<Enchantment>, Integer> entry : addition.entrySet()) {
            if (retVal.keySet().contains(entry.getKey())) {
                retVal.upgrade(entry.getKey(), Math.max(original.getLevel(entry.getKey()), entry.getValue()));
                continue;
            }
            if (!EnchantmentHelper.isEnchantmentCompatible((Collection)original.keySet(), entry.getKey())) continue;
            retVal.upgrade(entry.getKey(), entry.getValue().intValue());
        }
        return retVal.toImmutable();
    }

    public static boolean hasRunes(@Nullable ItemStack stack) {
        return !RuneManager.getRunes(stack).isEmpty();
    }

    @Nonnull
    public static List<Rune> getRunes(@Nullable ItemStack stack) {
        return stack == null ? ImmutableList.of() : (List)stack.getOrDefault(DataComponentsPM.INSCRIBED_RUNES.get(), (Object)ImmutableList.of());
    }

    public static void setRunes(@Nullable ItemStack stack, @Nullable List<Rune> runes) {
        if (stack != null && !stack.isEmpty() && runes != null && !runes.isEmpty()) {
            stack.set(DataComponentsPM.INSCRIBED_RUNES.get(), runes);
        }
    }

    public static void clearRunes(@Nullable ItemStack stack) {
        if (stack != null) {
            stack.remove(DataComponentsPM.INSCRIBED_RUNES.get());
        }
    }

    public static boolean hasRuneDefinition(RegistryAccess registryAccess, Holder<Enchantment> enchant) {
        return RuneManager.getRuneEnchantments(registryAccess).contains(enchant);
    }

    public static Optional<RuneEnchantmentDefinition> getRuneDefinition(RegistryAccess registryAccess, Holder<Enchantment> enchant) {
        return registryAccess.registryOrThrow(RegistryKeysPM.RUNE_ENCHANTMENT_DEFINITIONS).stream().filter(def -> ((Enchantment)def.result().value()).equals(enchant.value())).findFirst();
    }

    public static boolean isRuneKnown(Player player, Holder<Enchantment> enchant, RuneType runeType) {
        return ResearchManager.isResearchComplete(player, new RuneEnchantmentKey(enchant)) || ResearchManager.isResearchComplete(player, new RuneEnchantmentPartialKey(enchant, runeType));
    }
}

