/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.runes;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.AndRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ResearchRequirement;
import com.verdantartifice.primalmagick.common.runes.NounRune;
import com.verdantartifice.primalmagick.common.runes.Rune;
import com.verdantartifice.primalmagick.common.runes.SourceRune;
import com.verdantartifice.primalmagick.common.runes.VerbRune;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.enchantment.Enchantment;

public record RuneEnchantmentDefinition(Holder<Enchantment> result, VerbRune verb, NounRune noun, SourceRune source, Optional<AbstractRequirement<?>> requirementOpt) {
    public static Codec<RuneEnchantmentDefinition> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)Enchantment.CODEC.fieldOf("result").forGetter(RuneEnchantmentDefinition::result), (App)VerbRune.CODEC.fieldOf("verb").forGetter(RuneEnchantmentDefinition::verb), (App)NounRune.CODEC.fieldOf("noun").forGetter(RuneEnchantmentDefinition::noun), (App)SourceRune.CODEC.fieldOf("source").forGetter(RuneEnchantmentDefinition::source), (App)AbstractRequirement.dispatchCodec().optionalFieldOf("requirement").forGetter(RuneEnchantmentDefinition::requirementOpt)).apply((Applicative)instance, RuneEnchantmentDefinition::new));
    }

    public List<Rune> getRunes() {
        return List.of(this.verb(), this.noun(), this.source());
    }

    public static Builder builder(Holder<Enchantment> ench) {
        return new Builder(ench);
    }

    public static class Builder {
        protected final Holder<Enchantment> result;
        protected VerbRune verb;
        protected NounRune noun;
        protected SourceRune source;
        protected final List<AbstractRequirement<?>> requirements = new ArrayList();

        public Builder(Holder<Enchantment> result) {
            this.result = (Holder)Preconditions.checkNotNull(result);
        }

        public Builder verb(@Nonnull VerbRune verb) {
            this.verb = verb;
            return this;
        }

        public Builder noun(@Nonnull NounRune noun) {
            this.noun = noun;
            return this;
        }

        public Builder source(@Nonnull SourceRune source) {
            this.source = source;
            return this;
        }

        public Builder requirement(AbstractRequirement<?> req) {
            this.requirements.add(req);
            return this;
        }

        public Builder requiredResearch(ResourceKey<ResearchEntry> rawKey) {
            return this.requirement(new ResearchRequirement(new ResearchEntryKey(rawKey)));
        }

        protected Optional<AbstractRequirement<?>> getFinalRequirement() {
            if (this.requirements.isEmpty()) {
                return Optional.empty();
            }
            if (this.requirements.size() == 1) {
                return Optional.of(this.requirements.get(0));
            }
            return Optional.of(new AndRequirement(this.requirements));
        }

        private void validate() {
            if (this.verb == null) {
                throw new IllegalStateException("No verb rune for rune enchantment");
            }
            if (this.noun == null) {
                throw new IllegalStateException("No noun rune for rune enchantment");
            }
            if (this.source == null) {
                throw new IllegalStateException("No source rune for rune enchantment");
            }
        }

        public RuneEnchantmentDefinition build() {
            this.validate();
            return new RuneEnchantmentDefinition(this.result, this.verb, this.noun, this.source, this.getFinalRequirement());
        }
    }
}

