/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.rituals;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public interface ISaltPowered {
    default public boolean isBlockSaltPowered(@Nonnull BlockGetter world, @Nonnull BlockPos pos) {
        for (Direction dir : Direction.values()) {
            if (this.getSaltPower(world, pos.relative(dir), dir) <= 0) continue;
            return true;
        }
        return false;
    }

    default public int getSaltPower(@Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull Direction facing) {
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() instanceof ISaltPowered) {
            return ((ISaltPowered)state.getBlock()).getStrongSaltPower(state, world, pos, facing);
        }
        return 0;
    }

    default public int getStrongSaltPower(@Nonnull BlockState blockState, @Nonnull BlockGetter blockAccess, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return 0;
    }
}

