/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.rituals;

import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.PropMarkerPacket;
import com.verdantartifice.primalmagick.common.network.packets.fx.RemovePropMarkerPacket;
import com.verdantartifice.primalmagick.common.rituals.IRitualPropTileEntity;
import com.verdantartifice.primalmagick.common.rituals.IRitualStabilizer;
import com.verdantartifice.primalmagick.common.rituals.ISaltPowered;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public interface IRitualPropBlock
extends ISaltPowered,
IRitualStabilizer {
    public boolean isPropActivated(BlockState var1, Level var2, BlockPos var3);

    default public void onPropActivated(BlockState state, Level world, BlockPos pos, float stabilityBonus) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof IRitualPropTileEntity) {
            IRitualPropTileEntity propTile = (IRitualPropTileEntity)tile;
            propTile.notifyAltarOfPropActivation(stabilityBonus);
        }
    }

    default public boolean isPropOpen(BlockState state, Level world, BlockPos pos) {
        IRitualPropTileEntity propTile;
        BlockEntity tile = world.getBlockEntity(pos);
        return tile instanceof IRitualPropTileEntity && (propTile = (IRitualPropTileEntity)tile).isPropOpen();
    }

    default public void openProp(BlockState state, Level world, BlockPos pos, @Nullable Player player, BlockPos altarPos) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof IRitualPropTileEntity) {
            IRitualPropTileEntity propTile = (IRitualPropTileEntity)tile;
            propTile.setPropOpen(true);
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                PacketHandler.sendToAllAround(new PropMarkerPacket(pos), serverLevel, pos, 32.0);
            }
            if (player != null) {
                this.sendPropStatusMessage(player);
            }
        }
    }

    default public void closeProp(BlockState state, Level world, BlockPos pos) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof IRitualPropTileEntity) {
            IRitualPropTileEntity propTile = (IRitualPropTileEntity)tile;
            propTile.setPropOpen(false);
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                PacketHandler.sendToAllAround(new RemovePropMarkerPacket(pos), serverLevel, pos, 32.0);
            }
        }
    }

    default public void sendPropStatusMessage(@Nonnull Player player) {
        player.displayClientMessage((Component)Component.translatable((String)this.getPropTranslationKey()), false);
    }

    public String getPropTranslationKey();

    default public boolean isUniversal() {
        return false;
    }
}

