/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research.topics;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.research.topics.AbstractResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.ResearchTopicType;
import com.verdantartifice.primalmagick.common.research.topics.ResearchTopicTypesPM;
import com.verdantartifice.primalmagick.common.sources.Source;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class SourceResearchTopic
extends AbstractResearchTopic<SourceResearchTopic> {
    public static final MapCodec<SourceResearchTopic> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Source.CODEC.fieldOf("source").forGetter(SourceResearchTopic::getSource), (App)Codec.INT.fieldOf("page").forGetter(AbstractResearchTopic::getPage)).apply((Applicative)instance, SourceResearchTopic::new));
    public static final StreamCodec<ByteBuf, SourceResearchTopic> STREAM_CODEC = StreamCodec.composite(Source.STREAM_CODEC, SourceResearchTopic::getSource, (StreamCodec)ByteBufCodecs.VAR_INT, AbstractResearchTopic::getPage, SourceResearchTopic::new);
    protected final Source source;

    public SourceResearchTopic(Source source, int page) {
        super(page);
        this.source = source;
    }

    public Source getSource() {
        return this.source;
    }

    @Override
    public ResearchTopicType<SourceResearchTopic> getType() {
        return ResearchTopicTypesPM.SOURCE.get();
    }

    @Override
    public SourceResearchTopic withPage(int newPage) {
        return new SourceResearchTopic(this.source, newPage);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof SourceResearchTopic)) {
            return false;
        }
        SourceResearchTopic that = (SourceResearchTopic)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.source, that.source);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.source);
    }
}

