/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research.topics;

import com.mojang.serialization.MapCodec;
import com.verdantartifice.primalmagick.common.research.ResearchDisciplines;
import com.verdantartifice.primalmagick.common.research.topics.AbstractResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.ResearchTopicType;
import com.verdantartifice.primalmagick.common.research.topics.ResearchTopicTypesPM;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;

public class MainIndexResearchTopic
extends AbstractResearchTopic<MainIndexResearchTopic> {
    public static final MainIndexResearchTopic INSTANCE = new MainIndexResearchTopic();
    public static final MapCodec<MainIndexResearchTopic> CODEC = MapCodec.unit((Object)INSTANCE);
    public static final StreamCodec<ByteBuf, MainIndexResearchTopic> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);

    protected MainIndexResearchTopic() {
        super(0);
    }

    @Override
    public ResearchTopicType<MainIndexResearchTopic> getType() {
        return ResearchTopicTypesPM.MAIN_INDEX.get();
    }

    @Override
    public MainIndexResearchTopic withPage(int newPage) {
        return INSTANCE;
    }

    @Override
    public boolean isUnread(Player player) {
        return ResearchDisciplines.stream(player.registryAccess()).anyMatch(d -> d.isUnread(player));
    }

    @Override
    public Optional<Component> getUnreadTooltip(Player player) {
        int count = ResearchDisciplines.stream(player.registryAccess()).mapToInt(d -> d.isUnread(player) ? 1 : 0).sum();
        if (count == 1) {
            return Optional.of(Component.translatable((String)"tooltip.primalmagick.unread_count.discipline.single"));
        }
        if (count > 0) {
            return Optional.of(Component.translatable((String)"tooltip.primalmagick.unread_count.discipline.multiple", (Object[])new Object[]{count}));
        }
        return Optional.empty();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof MainIndexResearchTopic)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

