/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research.topics;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import com.verdantartifice.primalmagick.common.research.topics.AbstractResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.ResearchTopicType;
import com.verdantartifice.primalmagick.common.research.topics.ResearchTopicTypesPM;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;

public class LanguageResearchTopic
extends AbstractResearchTopic<LanguageResearchTopic> {
    public static final MapCodec<LanguageResearchTopic> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec(RegistryKeysPM.BOOK_LANGUAGES).fieldOf("language").forGetter(LanguageResearchTopic::getLanguage), (App)Codec.INT.fieldOf("page").forGetter(AbstractResearchTopic::getPage)).apply((Applicative)instance, LanguageResearchTopic::new));
    public static final StreamCodec<ByteBuf, LanguageResearchTopic> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec(RegistryKeysPM.BOOK_LANGUAGES), LanguageResearchTopic::getLanguage, (StreamCodec)ByteBufCodecs.VAR_INT, AbstractResearchTopic::getPage, LanguageResearchTopic::new);
    protected final ResourceKey<BookLanguage> language;

    public LanguageResearchTopic(ResourceKey<BookLanguage> language, int page) {
        super(page);
        this.language = language;
    }

    public ResourceKey<BookLanguage> getLanguage() {
        return this.language;
    }

    @Override
    public ResearchTopicType<LanguageResearchTopic> getType() {
        return ResearchTopicTypesPM.LANGUAGE.get();
    }

    @Override
    public LanguageResearchTopic withPage(int newPage) {
        return new LanguageResearchTopic(this.language, newPage);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof LanguageResearchTopic)) {
            return false;
        }
        LanguageResearchTopic that = (LanguageResearchTopic)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.language, that.language);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.language);
    }
}

