/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research.topics;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.research.topics.AbstractResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.ResearchTopicType;
import com.verdantartifice.primalmagick.common.research.topics.ResearchTopicTypesPM;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;

public class EntryResearchTopic
extends AbstractResearchTopic<EntryResearchTopic> {
    public static final MapCodec<EntryResearchTopic> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResearchEntryKey.CODEC.fieldOf("entry").forGetter(EntryResearchTopic::getEntry), (App)Codec.INT.fieldOf("page").forGetter(AbstractResearchTopic::getPage)).apply((Applicative)instance, EntryResearchTopic::new));
    public static final StreamCodec<ByteBuf, EntryResearchTopic> STREAM_CODEC = StreamCodec.composite(ResearchEntryKey.STREAM_CODEC, EntryResearchTopic::getEntry, (StreamCodec)ByteBufCodecs.VAR_INT, AbstractResearchTopic::getPage, EntryResearchTopic::new);
    protected final ResearchEntryKey entry;

    public EntryResearchTopic(ResearchEntryKey entryKey, int page) {
        super(page);
        this.entry = entryKey;
    }

    public EntryResearchTopic(ResourceKey<ResearchEntry> entryRawKey, int page) {
        super(page);
        this.entry = new ResearchEntryKey(entryRawKey);
    }

    public ResearchEntryKey getEntry() {
        return this.entry;
    }

    @Override
    public ResearchTopicType<EntryResearchTopic> getType() {
        return ResearchTopicTypesPM.RESEARCH_ENTRY.get();
    }

    @Override
    public EntryResearchTopic withPage(int newPage) {
        return new EntryResearchTopic(this.entry, newPage);
    }

    @Override
    public boolean isUnread(Player player) {
        ResearchEntry e = ResearchEntries.getEntry(player.registryAccess(), this.entry);
        return e != null && e.isUnread(player);
    }

    @Override
    public Optional<Component> getUnreadTooltip(Player player) {
        return this.isUnread(player) ? Optional.of(Component.translatable((String)"tooltip.primalmagick.unread_count.entry.single")) : Optional.empty();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof EntryResearchTopic)) {
            return false;
        }
        EntryResearchTopic that = (EntryResearchTopic)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.entry, that.entry);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.entry);
    }
}

