/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research.topics;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.research.topics.AbstractResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.ResearchTopicType;
import com.verdantartifice.primalmagick.common.research.topics.ResearchTopicTypesPM;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.enchantment.Enchantment;

public class EnchantmentResearchTopic
extends AbstractResearchTopic<EnchantmentResearchTopic> {
    public static final MapCodec<EnchantmentResearchTopic> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Enchantment.CODEC.fieldOf("enchantment").forGetter(EnchantmentResearchTopic::getEnchantment), (App)Codec.INT.fieldOf("page").forGetter(AbstractResearchTopic::getPage)).apply((Applicative)instance, EnchantmentResearchTopic::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, EnchantmentResearchTopic> STREAM_CODEC = StreamCodec.composite((StreamCodec)Enchantment.STREAM_CODEC, EnchantmentResearchTopic::getEnchantment, (StreamCodec)ByteBufCodecs.VAR_INT, AbstractResearchTopic::getPage, EnchantmentResearchTopic::new);
    protected final Holder<Enchantment> enchantment;

    public EnchantmentResearchTopic(Holder<Enchantment> enchantment, int page) {
        super(page);
        this.enchantment = enchantment;
    }

    public Holder<Enchantment> getEnchantment() {
        return this.enchantment;
    }

    @Override
    public ResearchTopicType<EnchantmentResearchTopic> getType() {
        return ResearchTopicTypesPM.ENCHANTMENT.get();
    }

    @Override
    public EnchantmentResearchTopic withPage(int newPage) {
        return new EnchantmentResearchTopic(this.enchantment, newPage);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof EnchantmentResearchTopic)) {
            return false;
        }
        EnchantmentResearchTopic that = (EnchantmentResearchTopic)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.enchantment, that.enchantment);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.enchantment);
    }
}

