/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research.topics;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.research.ResearchDiscipline;
import com.verdantartifice.primalmagick.common.research.ResearchDisciplines;
import com.verdantartifice.primalmagick.common.research.keys.ResearchDisciplineKey;
import com.verdantartifice.primalmagick.common.research.topics.AbstractResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.ResearchTopicType;
import com.verdantartifice.primalmagick.common.research.topics.ResearchTopicTypesPM;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;

public class DisciplineResearchTopic
extends AbstractResearchTopic<DisciplineResearchTopic> {
    public static final MapCodec<DisciplineResearchTopic> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResearchDisciplineKey.CODEC.fieldOf("data").forGetter(DisciplineResearchTopic::getDiscipline), (App)Codec.INT.fieldOf("page").forGetter(AbstractResearchTopic::getPage)).apply((Applicative)instance, DisciplineResearchTopic::new));
    public static final StreamCodec<ByteBuf, DisciplineResearchTopic> STREAM_CODEC = StreamCodec.composite(ResearchDisciplineKey.STREAM_CODEC, DisciplineResearchTopic::getDiscipline, (StreamCodec)ByteBufCodecs.VAR_INT, AbstractResearchTopic::getPage, DisciplineResearchTopic::new);
    protected final ResearchDisciplineKey discipline;

    public DisciplineResearchTopic(ResearchDisciplineKey disciplineKey, int page) {
        super(page);
        this.discipline = disciplineKey;
    }

    public ResearchDisciplineKey getDiscipline() {
        return this.discipline;
    }

    @Override
    public ResearchTopicType<DisciplineResearchTopic> getType() {
        return ResearchTopicTypesPM.DISCIPLINE.get();
    }

    @Override
    public DisciplineResearchTopic withPage(int newPage) {
        return new DisciplineResearchTopic(this.discipline, newPage);
    }

    @Override
    public boolean isUnread(Player player) {
        ResearchDiscipline d = ResearchDisciplines.getDiscipline(player.registryAccess(), this.discipline);
        return d != null && d.isUnread(player);
    }

    @Override
    public Optional<Component> getUnreadTooltip(Player player) {
        int count;
        ResearchDiscipline d = ResearchDisciplines.getDiscipline(player.registryAccess(), this.discipline);
        int n = count = d == null ? 0 : d.getUnreadEntryCount(player);
        if (count == 1) {
            return Optional.of(Component.translatable((String)"tooltip.primalmagick.unread_count.entry.single"));
        }
        if (count > 0) {
            return Optional.of(Component.translatable((String)"tooltip.primalmagick.unread_count.entry.multiple", (Object[])new Object[]{count}));
        }
        return Optional.empty();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DisciplineResearchTopic)) {
            return false;
        }
        DisciplineResearchTopic that = (DisciplineResearchTopic)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.discipline, that.discipline);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.discipline);
    }
}

