/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research.topics;

import com.mojang.serialization.Codec;
import com.verdantartifice.primalmagick.common.research.topics.ResearchTopicType;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;

public abstract class AbstractResearchTopic<T extends AbstractResearchTopic<T>> {
    protected final int page;

    public static Codec<AbstractResearchTopic<?>> dispatchCodec() {
        return Services.RESEARCH_TOPIC_TYPES_REGISTRY.codec().dispatch("topic_type", AbstractResearchTopic::getType, ResearchTopicType::codec);
    }

    public static StreamCodec<RegistryFriendlyByteBuf, AbstractResearchTopic<?>> dispatchStreamCodec() {
        return Services.RESEARCH_TOPIC_TYPES_REGISTRY.registryFriendlyStreamCodec().dispatch(AbstractResearchTopic::getType, ResearchTopicType::streamCodec);
    }

    protected AbstractResearchTopic(int page) {
        this.page = page;
    }

    public abstract ResearchTopicType<T> getType();

    public int getPage() {
        return this.page;
    }

    public abstract T withPage(int var1);

    public boolean isUnread(Player player) {
        return false;
    }

    public Optional<Component> getUnreadTooltip(Player player) {
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AbstractResearchTopic)) {
            return false;
        }
        AbstractResearchTopic that = (AbstractResearchTopic)o;
        return this.page == that.page;
    }

    public int hashCode() {
        return Objects.hashCode(this.page);
    }
}

