/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research.requirements;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.research.IconDefinition;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.IVanillaStatRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.RequirementCategory;
import com.verdantartifice.primalmagick.common.research.requirements.RequirementType;
import com.verdantartifice.primalmagick.common.research.requirements.RequirementsPM;
import com.verdantartifice.primalmagick.platform.Services;
import io.netty.buffer.ByteBuf;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class VanillaItemUsedStatRequirement
extends AbstractRequirement<VanillaItemUsedStatRequirement>
implements IVanillaStatRequirement {
    public static final MapCodec<VanillaItemUsedStatRequirement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("item").xmap(loc -> (Item)Services.ITEMS_REGISTRY.get((ResourceLocation)loc), item -> Services.ITEMS_REGISTRY.getKey(item)).forGetter(req -> (Item)req.stat.getValue()), (App)Codec.INT.fieldOf("threshold").forGetter(VanillaItemUsedStatRequirement::getThreshold)).apply((Applicative)instance, VanillaItemUsedStatRequirement::new));
    public static final StreamCodec<ByteBuf, VanillaItemUsedStatRequirement> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC.map(loc -> (Item)Services.ITEMS_REGISTRY.get((ResourceLocation)loc), item -> Services.ITEMS_REGISTRY.getKey(item)), req -> (Item)req.stat.getValue(), (StreamCodec)ByteBufCodecs.VAR_INT, VanillaItemUsedStatRequirement::getThreshold, VanillaItemUsedStatRequirement::new);
    protected final Stat<Item> stat;
    protected final int threshold;

    public VanillaItemUsedStatRequirement(Item item, int threshold) {
        this((Stat<Item>)Stats.ITEM_USED.get((Object)((Item)Preconditions.checkNotNull((Object)item))), threshold);
    }

    protected VanillaItemUsedStatRequirement(Stat<Item> stat, int threshold) {
        this.stat = stat;
        this.threshold = threshold;
    }

    @Override
    public Stat<?> getStat() {
        return this.stat;
    }

    @Override
    public ResourceLocation getStatTypeLoc() {
        return BuiltInRegistries.STAT_TYPE.getKey((Object)this.stat.getType());
    }

    @Override
    public ResourceLocation getStatValueLoc() {
        return Services.ITEMS_REGISTRY.getKey((Item)this.stat.getValue());
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public Component getStatDescription() {
        Component baseLabel = this.stat.getType().getDisplayName();
        Component itemLabel = ((Item)this.stat.getValue()).getDescription();
        return Component.translatable((String)"tooltip.primalmagick.stat_description.vanilla", (Object[])new Object[]{baseLabel, itemLabel});
    }

    @Override
    public IconDefinition getIconDefinition() {
        return IconDefinition.of((ItemLike)this.stat.getValue());
    }

    @Override
    public int getCurrentValue(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return serverPlayer.getStats().getValue(this.stat);
        }
        if (Services.PLATFORM.isClientDist()) {
            return ClientUtils.getStatsCounter().getValue(this.stat);
        }
        throw new IllegalStateException("Player is neither server nor client side!");
    }

    @Override
    public boolean isMetBy(Player player) {
        return this.getCurrentValue(player) >= this.threshold;
    }

    @Override
    public void consumeComponents(Player player) {
    }

    @Override
    public boolean forceComplete(Player player) {
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer && this.threshold > this.getCurrentValue((Player)(serverPlayer = (ServerPlayer)player))) {
            serverPlayer.getStats().setValue((Player)serverPlayer, this.stat, this.threshold);
            return true;
        }
        return false;
    }

    @Override
    public RequirementCategory getCategory() {
        return RequirementCategory.STAT;
    }

    @Override
    public Stream<AbstractRequirement<?>> streamByCategory(RequirementCategory category) {
        return category == this.getCategory() ? Stream.of(this) : Stream.empty();
    }

    @Override
    protected RequirementType<VanillaItemUsedStatRequirement> getType() {
        return RequirementsPM.VANILLA_ITEM_USED_STAT.get();
    }
}

