/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research.requirements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.research.IconDefinition;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.IVanillaStatRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.RequirementCategory;
import com.verdantartifice.primalmagick.common.research.requirements.RequirementType;
import com.verdantartifice.primalmagick.common.research.requirements.RequirementsPM;
import com.verdantartifice.primalmagick.platform.Services;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;

public class VanillaCustomStatRequirement
extends AbstractRequirement<VanillaCustomStatRequirement>
implements IVanillaStatRequirement {
    public static final MapCodec<VanillaCustomStatRequirement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("statValue").forGetter(VanillaCustomStatRequirement::getStatValueLoc), (App)Codec.INT.fieldOf("threshold").forGetter(VanillaCustomStatRequirement::getThreshold), (App)IconDefinition.CODEC.fieldOf("iconDefinition").forGetter(VanillaCustomStatRequirement::getIconDefinition)).apply((Applicative)instance, VanillaCustomStatRequirement::new));
    public static final StreamCodec<ByteBuf, VanillaCustomStatRequirement> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, VanillaCustomStatRequirement::getStatValueLoc, (StreamCodec)ByteBufCodecs.VAR_INT, VanillaCustomStatRequirement::getThreshold, IconDefinition.STREAM_CODEC, VanillaCustomStatRequirement::getIconDefinition, VanillaCustomStatRequirement::new);
    protected final ResourceLocation statValueLocation;
    protected final int threshold;
    protected final IconDefinition iconDefinition;
    protected Stat<ResourceLocation> statCache = null;

    public VanillaCustomStatRequirement(ResourceLocation loc, int threshold, IconDefinition iconDefinition) {
        this.statValueLocation = loc;
        this.threshold = threshold;
        this.iconDefinition = iconDefinition;
    }

    @Override
    public Stat<?> getStat() {
        if (this.statCache == null) {
            ObjectArrayList statsList = new ObjectArrayList(Stats.CUSTOM.iterator());
            this.statCache = statsList.stream().filter(s -> ((ResourceLocation)s.getValue()).equals((Object)this.statValueLocation)).findFirst().orElse(null);
        }
        return this.statCache;
    }

    @Override
    public ResourceLocation getStatTypeLoc() {
        return BuiltInRegistries.STAT_TYPE.getKey((Object)Stats.CUSTOM);
    }

    @Override
    public ResourceLocation getStatValueLoc() {
        return this.statValueLocation;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public Component getStatDescription() {
        String key = String.join((CharSequence)".", "stat", this.statValueLocation.getNamespace(), this.statValueLocation.getPath());
        return Component.translatable((String)key);
    }

    @Override
    public IconDefinition getIconDefinition() {
        return this.iconDefinition;
    }

    @Override
    public int getCurrentValue(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return serverPlayer.getStats().getValue(this.getStat());
        }
        if (Services.PLATFORM.isClientDist()) {
            return ClientUtils.getStatsCounter().getValue(this.getStat());
        }
        throw new IllegalStateException("Player is neither server nor client side!");
    }

    @Override
    public boolean isMetBy(Player player) {
        return this.getCurrentValue(player) >= this.threshold;
    }

    @Override
    public void consumeComponents(Player player) {
    }

    @Override
    public boolean forceComplete(Player player) {
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer && this.threshold > this.getCurrentValue((Player)(serverPlayer = (ServerPlayer)player))) {
            serverPlayer.getStats().setValue((Player)serverPlayer, this.getStat(), this.threshold);
            return true;
        }
        return false;
    }

    @Override
    public RequirementCategory getCategory() {
        return RequirementCategory.STAT;
    }

    @Override
    public Stream<AbstractRequirement<?>> streamByCategory(RequirementCategory category) {
        return category == this.getCategory() ? Stream.of(this) : Stream.empty();
    }

    @Override
    protected RequirementType<VanillaCustomStatRequirement> getType() {
        return RequirementsPM.VANILLA_CUSTOM_STAT.get();
    }
}

