/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research.requirements;

import com.google.common.base.Preconditions;
import com.mojang.serialization.MapCodec;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.research.keys.AbstractResearchKey;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.RequirementCategory;
import com.verdantartifice.primalmagick.common.research.requirements.RequirementType;
import com.verdantartifice.primalmagick.common.research.requirements.RequirementsPM;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;

public class ResearchRequirement
extends AbstractRequirement<ResearchRequirement> {
    protected final AbstractResearchKey<?> rootKey;

    public static MapCodec<ResearchRequirement> codec() {
        return AbstractResearchKey.dispatchCodec().fieldOf("rootKey").xmap(ResearchRequirement::new, req -> req.rootKey);
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ResearchRequirement> streamCodec() {
        return AbstractResearchKey.dispatchStreamCodec().map(ResearchRequirement::new, req -> req.rootKey);
    }

    public ResearchRequirement(AbstractResearchKey<?> rootKey) {
        this.rootKey = (AbstractResearchKey)Preconditions.checkNotNull(rootKey);
    }

    public AbstractResearchKey<?> getRootKey() {
        return this.rootKey;
    }

    @Override
    public boolean isMetBy(Player player) {
        return player == null ? false : this.rootKey.isKnownBy(player);
    }

    @Override
    public void consumeComponents(Player player) {
    }

    @Override
    public boolean forceComplete(Player player) {
        AbstractResearchKey<?> abstractResearchKey = this.rootKey;
        if (abstractResearchKey instanceof ResearchEntryKey) {
            ResearchEntryKey entryKey = (ResearchEntryKey)abstractResearchKey;
            return ResearchManager.completeResearch(player, entryKey, true, true, false);
        }
        Services.CAPABILITIES.knowledge(player).ifPresent(k -> k.addResearch(this.rootKey));
        return true;
    }

    @Override
    public RequirementCategory getCategory() {
        return this.rootKey.getRequirementCategory();
    }

    @Override
    public Stream<AbstractRequirement<?>> streamByCategory(RequirementCategory category) {
        return category == this.getCategory() ? Stream.of(this) : Stream.empty();
    }

    @Override
    public boolean contains(AbstractResearchKey<?> researchKey) {
        return this.rootKey.equals(researchKey);
    }

    @Override
    public boolean satisfiedBy(AbstractResearchKey<?> researchKey) {
        return this.contains(researchKey);
    }

    @Override
    public Stream<AbstractResearchKey<?>> streamKeys() {
        return Stream.of(this.rootKey);
    }

    @Override
    protected RequirementType<ResearchRequirement> getType() {
        return RequirementsPM.RESEARCH.get();
    }
}

