/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research.requirements;

import com.mojang.serialization.MapCodec;
import com.verdantartifice.primalmagick.common.registries.IRegistryItem;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.AndRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ExpertiseRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ItemStackRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ItemTagRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.KnowledgeRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.OrRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.QuorumRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.RequirementType;
import com.verdantartifice.primalmagick.common.research.requirements.ResearchRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.StatRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.VanillaCustomStatRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.VanillaItemUsedStatRequirement;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class RequirementsPM {
    public static final IRegistryItem<RequirementType<?>, RequirementType<ResearchRequirement>> RESEARCH = RequirementsPM.register("research", ResearchRequirement::codec, ResearchRequirement::streamCodec);
    public static final IRegistryItem<RequirementType<?>, RequirementType<KnowledgeRequirement>> KNOWLEDGE = RequirementsPM.register("knowledge", () -> KnowledgeRequirement.CODEC, () -> KnowledgeRequirement.STREAM_CODEC);
    public static final IRegistryItem<RequirementType<?>, RequirementType<ItemStackRequirement>> ITEM_STACK = RequirementsPM.register("item_stack", () -> ItemStackRequirement.CODEC, () -> ItemStackRequirement.STREAM_CODEC);
    public static final IRegistryItem<RequirementType<?>, RequirementType<ItemTagRequirement>> ITEM_TAG = RequirementsPM.register("item_tag", () -> ItemTagRequirement.CODEC, () -> ItemTagRequirement.STREAM_CODEC);
    public static final IRegistryItem<RequirementType<?>, RequirementType<StatRequirement>> STAT = RequirementsPM.register("stat", () -> StatRequirement.CODEC, () -> StatRequirement.STREAM_CODEC);
    public static final IRegistryItem<RequirementType<?>, RequirementType<ExpertiseRequirement>> EXPERTISE = RequirementsPM.register("expertise", ExpertiseRequirement::codec, ExpertiseRequirement::streamCodec);
    public static final IRegistryItem<RequirementType<?>, RequirementType<VanillaItemUsedStatRequirement>> VANILLA_ITEM_USED_STAT = RequirementsPM.register("vanilla_item_used_stat", () -> VanillaItemUsedStatRequirement.CODEC, () -> VanillaItemUsedStatRequirement.STREAM_CODEC);
    public static final IRegistryItem<RequirementType<?>, RequirementType<VanillaCustomStatRequirement>> VANILLA_CUSTOM_STAT = RequirementsPM.register("vanilla_custom_stat", () -> VanillaCustomStatRequirement.CODEC, () -> VanillaCustomStatRequirement.STREAM_CODEC);
    public static final IRegistryItem<RequirementType<?>, RequirementType<AndRequirement>> AND = RequirementsPM.register("and", AndRequirement::codec, AndRequirement::streamCodec);
    public static final IRegistryItem<RequirementType<?>, RequirementType<OrRequirement>> OR = RequirementsPM.register("or", OrRequirement::codec, OrRequirement::streamCodec);
    public static final IRegistryItem<RequirementType<?>, RequirementType<QuorumRequirement>> QUORUM = RequirementsPM.register("quorum", QuorumRequirement::codec, QuorumRequirement::streamCodec);

    public static void init() {
        Services.REQUIREMENT_TYPES_REGISTRY.init();
    }

    protected static <T extends AbstractRequirement<T>> IRegistryItem<RequirementType<?>, RequirementType<T>> register(String id, Supplier<MapCodec<T>> codecSupplier, Supplier<StreamCodec<? super RegistryFriendlyByteBuf, T>> streamCodecSupplier) {
        return Services.REQUIREMENT_TYPES_REGISTRY.register(id, () -> new RequirementType(ResourceUtils.loc(id), codecSupplier, streamCodecSupplier));
    }
}

