/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research.requirements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.research.ResearchDiscipline;
import com.verdantartifice.primalmagick.common.research.ResearchTier;
import com.verdantartifice.primalmagick.common.research.keys.ResearchDisciplineKey;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.RequirementCategory;
import com.verdantartifice.primalmagick.common.research.requirements.RequirementType;
import com.verdantartifice.primalmagick.common.research.requirements.RequirementsPM;
import com.verdantartifice.primalmagick.common.stats.ExpertiseManager;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ExpertiseRequirement
extends AbstractRequirement<ExpertiseRequirement> {
    protected final ResearchDisciplineKey discipline;
    protected final ResearchTier tier;
    protected final Optional<Integer> thresholdOverrideOpt;
    protected Optional<Integer> thresholdCache = Optional.empty();

    public static MapCodec<ExpertiseRequirement> codec() {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResearchDisciplineKey.CODEC.fieldOf("discipline").forGetter(ExpertiseRequirement::getDiscipline), (App)ResearchTier.CODEC.fieldOf("tier").forGetter(ExpertiseRequirement::getTier), (App)Codec.INT.optionalFieldOf("thresholdOverride").forGetter(r -> r.thresholdOverrideOpt)).apply((Applicative)instance, ExpertiseRequirement::new));
    }

    public static StreamCodec<ByteBuf, ExpertiseRequirement> streamCodec() {
        return StreamCodec.composite(ResearchDisciplineKey.STREAM_CODEC, ExpertiseRequirement::getDiscipline, ResearchTier.STREAM_CODEC, ExpertiseRequirement::getTier, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.VAR_INT), req -> req.thresholdOverrideOpt, ExpertiseRequirement::new);
    }

    protected ExpertiseRequirement(ResearchDisciplineKey discipline, ResearchTier tier, Optional<Integer> thresholdOverrideOpt) {
        this.discipline = discipline;
        this.tier = tier;
        this.thresholdOverrideOpt = thresholdOverrideOpt;
    }

    public ExpertiseRequirement(ResourceKey<ResearchDiscipline> discipline, ResearchTier tier) {
        this(new ResearchDisciplineKey(discipline), tier, Optional.empty());
    }

    public ExpertiseRequirement(ResourceKey<ResearchDiscipline> discipline, ResearchTier tier, int thresholdOverride) {
        this(new ResearchDisciplineKey(discipline), tier, Optional.of(thresholdOverride));
    }

    public ResearchDisciplineKey getDiscipline() {
        return this.discipline;
    }

    public ResearchTier getTier() {
        return this.tier;
    }

    public int getThreshold(Level level) {
        return this.thresholdOverrideOpt.orElseGet(() -> this.getThresholdInner(level));
    }

    protected int getThresholdInner(Level level) {
        if (this.thresholdCache.isEmpty()) {
            this.thresholdCache = Optional.of(ExpertiseManager.getThreshold(level, this.discipline, this.tier).orElse(0));
        }
        return this.thresholdCache.get();
    }

    @Override
    public boolean isMetBy(Player player) {
        if (player == null) {
            return false;
        }
        return this.discipline.isKnownBy(player) && ExpertiseManager.getValue(player, this.discipline).orElse(0) >= this.getThreshold(player.level());
    }

    @Override
    public void consumeComponents(Player player) {
    }

    @Override
    public boolean forceComplete(Player player) {
        ExpertiseManager.setValueIfMax(player, this.discipline, this.getThreshold(player.level()));
        return true;
    }

    @Override
    public RequirementCategory getCategory() {
        return RequirementCategory.STAT;
    }

    @Override
    public Stream<AbstractRequirement<?>> streamByCategory(RequirementCategory category) {
        return category == this.getCategory() ? Stream.of(this) : Stream.empty();
    }

    @Override
    protected RequirementType<ExpertiseRequirement> getType() {
        return RequirementsPM.EXPERTISE.get();
    }
}

