/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research.requirements;

import com.mojang.serialization.MapCodec;
import com.verdantartifice.primalmagick.common.research.keys.AbstractResearchKey;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.RequirementCategory;
import com.verdantartifice.primalmagick.common.research.requirements.RequirementType;
import com.verdantartifice.primalmagick.common.research.requirements.RequirementsPM;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;

public class AndRequirement
extends AbstractRequirement<AndRequirement> {
    protected final List<AbstractRequirement<?>> subs = new ArrayList();

    public static MapCodec<AndRequirement> codec() {
        return AbstractRequirement.dispatchCodec().listOf().fieldOf("subRequirements").xmap(AndRequirement::new, req -> req.subs);
    }

    public static StreamCodec<RegistryFriendlyByteBuf, AndRequirement> streamCodec() {
        return AbstractRequirement.dispatchStreamCodec().apply(ByteBufCodecs.list()).map(AndRequirement::new, req -> req.subs);
    }

    public AndRequirement(List<AbstractRequirement<?>> components) {
        this.subs.addAll(components);
    }

    public AndRequirement(AbstractRequirement<?> ... components) {
        this(Arrays.asList(components));
    }

    @Override
    public boolean isMetBy(Player player) {
        if (player == null) {
            return false;
        }
        return this.subs.stream().allMatch(req -> req.isMetBy(player));
    }

    @Override
    public void consumeComponents(Player player) {
        this.subs.forEach(req -> req.consumeComponents(player));
    }

    @Override
    public boolean forceComplete(Player player) {
        return this.subs.stream().map(req -> req.forceComplete(player)).allMatch(val -> val);
    }

    @Override
    public RequirementCategory getCategory() {
        return RequirementCategory.COMPOUND;
    }

    @Override
    public Stream<AbstractRequirement<?>> streamByCategory(RequirementCategory category) {
        Stream<Object> selfStream = category == this.getCategory() ? Stream.of(this) : Stream.empty();
        return Stream.concat(selfStream, this.subs.stream().flatMap(req -> req.streamByCategory(category)));
    }

    @Override
    public boolean contains(AbstractResearchKey<?> researchKey) {
        return this.subs.stream().anyMatch(req -> req.contains(researchKey));
    }

    @Override
    public boolean satisfiedBy(AbstractResearchKey<?> researchKey) {
        return this.subs.stream().allMatch(req -> req.satisfiedBy(researchKey));
    }

    @Override
    public Stream<AbstractResearchKey<?>> streamKeys() {
        return this.subs.stream().flatMap(req -> req.streamKeys());
    }

    @Override
    protected RequirementType<AndRequirement> getType() {
        return RequirementsPM.AND.get();
    }
}

