/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research.requirements;

import com.mojang.serialization.Codec;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.ResearchTier;
import com.verdantartifice.primalmagick.common.research.keys.AbstractResearchKey;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.research.requirements.RequirementCategory;
import com.verdantartifice.primalmagick.common.research.requirements.RequirementType;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;

public abstract class AbstractRequirement<T extends AbstractRequirement<T>> {
    public static Codec<AbstractRequirement<?>> dispatchCodec() {
        return Services.REQUIREMENT_TYPES_REGISTRY.codec().dispatch("requirement_type", AbstractRequirement::getType, type -> type.codecSupplier().get());
    }

    public static StreamCodec<RegistryFriendlyByteBuf, AbstractRequirement<?>> dispatchStreamCodec() {
        return Services.REQUIREMENT_TYPES_REGISTRY.registryFriendlyStreamCodec().dispatch(AbstractRequirement::getType, type -> type.streamCodecSupplier().get());
    }

    public abstract boolean isMetBy(@Nullable Player var1);

    public abstract void consumeComponents(@Nullable Player var1);

    public abstract boolean forceComplete(@Nullable Player var1);

    public abstract RequirementCategory getCategory();

    public abstract Stream<AbstractRequirement<?>> streamByCategory(RequirementCategory var1);

    public boolean contains(AbstractResearchKey<?> researchKey) {
        return false;
    }

    public boolean satisfiedBy(AbstractResearchKey<?> researchKey) {
        return false;
    }

    public Stream<AbstractResearchKey<?>> streamKeys() {
        return Stream.empty();
    }

    public Optional<ResearchTier> getResearchTier(RegistryAccess registryAccess) {
        Optional<ResearchTier> retVal = Optional.empty();
        for (AbstractResearchKey<?> rawKey : this.streamKeys().toList()) {
            ResearchEntryKey entryKey;
            ResearchEntry entry;
            if (!(rawKey instanceof ResearchEntryKey) || (entry = ResearchEntries.getEntry(registryAccess, entryKey = (ResearchEntryKey)rawKey)) == null) continue;
            Optional<ResearchTier> tierOpt = entry.tierOpt();
            if (!retVal.isEmpty() && (!tierOpt.isPresent() || tierOpt.get().compareTo(retVal.get()) <= 0)) continue;
            retVal = tierOpt;
        }
        return retVal;
    }

    protected abstract RequirementType<T> getType();

    public static AbstractRequirement<?> fromNetwork(RegistryFriendlyByteBuf buf) {
        return (AbstractRequirement)AbstractRequirement.dispatchStreamCodec().decode((Object)buf);
    }

    public void toNetwork(RegistryFriendlyByteBuf buf) {
        AbstractRequirement.dispatchStreamCodec().encode((Object)buf, (Object)this);
    }
}

