/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research.keys;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import com.verdantartifice.primalmagick.common.research.IconDefinition;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.keys.AbstractResearchKey;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.research.keys.ResearchKeyType;
import com.verdantartifice.primalmagick.common.research.keys.ResearchKeyTypesPM;
import com.verdantartifice.primalmagick.common.research.requirements.RequirementCategory;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class ResearchStageKey
extends AbstractResearchKey<ResearchStageKey> {
    public static final MapCodec<ResearchStageKey> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec(RegistryKeysPM.RESEARCH_ENTRIES).fieldOf("rootKey").forGetter(ResearchStageKey::getRootKey), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("stage").forGetter(ResearchStageKey::getStage)).apply((Applicative)instance, ResearchStageKey::new));
    public static final StreamCodec<ByteBuf, ResearchStageKey> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec(RegistryKeysPM.RESEARCH_ENTRIES), ResearchStageKey::getRootKey, (StreamCodec)ByteBufCodecs.VAR_INT, ResearchStageKey::getStage, ResearchStageKey::new);
    private static final ResourceLocation ICON_UNKNOWN = ResourceUtils.loc("textures/research/research_unknown.png");
    protected final ResourceKey<ResearchEntry> rootKey;
    protected final int stage;
    protected final ResearchEntryKey strippedKey;

    public ResearchStageKey(ResourceKey<ResearchEntry> rootKey, int stage) {
        this.rootKey = rootKey;
        this.stage = stage;
        this.strippedKey = new ResearchEntryKey(rootKey);
    }

    public ResourceKey<ResearchEntry> getRootKey() {
        return this.rootKey;
    }

    public int getStage() {
        return this.stage;
    }

    @Override
    public String toString() {
        return this.rootKey.location().toString() + "@" + this.stage;
    }

    @Override
    public RequirementCategory getRequirementCategory() {
        return RequirementCategory.RESEARCH;
    }

    @Override
    protected ResearchKeyType<ResearchStageKey> getType() {
        return ResearchKeyTypesPM.RESEARCH_STAGE.get();
    }

    @Override
    public IconDefinition getIcon(RegistryAccess registryAccess) {
        return registryAccess.registryOrThrow(RegistryKeysPM.RESEARCH_ENTRIES).getHolder(this.rootKey).flatMap(ref -> ((ResearchEntry)ref.value()).iconOpt()).orElse(IconDefinition.of(ICON_UNKNOWN));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.rootKey.registry(), this.rootKey.location(), this.stage);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResearchStageKey other = (ResearchStageKey)obj;
        return Objects.equals(this.rootKey, other.rootKey) && this.stage == other.stage;
    }

    @Override
    public boolean isKnownBy(Player player) {
        if (player == null) {
            return false;
        }
        MutableBoolean retVal = new MutableBoolean(false);
        Services.CAPABILITIES.knowledge(player).ifPresent(knowledge -> {
            int currentStage = knowledge.getResearchStage(this.strippedKey) + 1;
            retVal.setValue(currentStage >= this.getStage());
        });
        return retVal.booleanValue();
    }
}

