/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research.keys;

import com.mojang.serialization.Codec;
import com.verdantartifice.primalmagick.common.research.IconDefinition;
import com.verdantartifice.primalmagick.common.research.keys.ResearchKeyType;
import com.verdantartifice.primalmagick.common.research.requirements.RequirementCategory;
import com.verdantartifice.primalmagick.platform.Services;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.mutable.MutableBoolean;

public abstract class AbstractResearchKey<T extends AbstractResearchKey<T>> {
    public static Codec<AbstractResearchKey<?>> dispatchCodec() {
        return Services.RESEARCH_KEY_TYPES_REGISTRY.codec().dispatch("key_type", AbstractResearchKey::getType, ResearchKeyType::codec);
    }

    public static StreamCodec<RegistryFriendlyByteBuf, AbstractResearchKey<?>> dispatchStreamCodec() {
        return Services.RESEARCH_KEY_TYPES_REGISTRY.registryFriendlyStreamCodec().dispatch(AbstractResearchKey::getType, ResearchKeyType::streamCodec);
    }

    public abstract String toString();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract RequirementCategory getRequirementCategory();

    protected abstract ResearchKeyType<T> getType();

    public abstract IconDefinition getIcon(RegistryAccess var1);

    public boolean isKnownBy(@Nullable Player player) {
        if (player == null) {
            return false;
        }
        MutableBoolean retVal = new MutableBoolean(false);
        Services.CAPABILITIES.knowledge(player).ifPresent(knowledge -> retVal.setValue(knowledge.isResearchComplete(player.level().registryAccess(), this)));
        return retVal.booleanValue();
    }

    public static AbstractResearchKey<?> fromNetwork(RegistryFriendlyByteBuf buf) {
        return (AbstractResearchKey)AbstractResearchKey.dispatchStreamCodec().decode((Object)buf);
    }

    public void toNetwork(RegistryFriendlyByteBuf buf) {
        AbstractResearchKey.dispatchStreamCodec().encode((Object)buf, (Object)this);
    }
}

