/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research;

import com.verdantartifice.primalmagick.common.advancements.critereon.CriteriaTriggersPM;
import com.verdantartifice.primalmagick.common.affinities.AffinityIndexEntry;
import com.verdantartifice.primalmagick.common.affinities.AffinityManager;
import com.verdantartifice.primalmagick.common.attunements.AttunementManager;
import com.verdantartifice.primalmagick.common.attunements.AttunementType;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerKnowledge;
import com.verdantartifice.primalmagick.common.crafting.recipe_book.ArcaneRecipeBookManager;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.misc.UnlockDisciplinePacket;
import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import com.verdantartifice.primalmagick.common.research.IScanTrigger;
import com.verdantartifice.primalmagick.common.research.KnowledgeType;
import com.verdantartifice.primalmagick.common.research.ResearchAddendum;
import com.verdantartifice.primalmagick.common.research.ResearchDiscipline;
import com.verdantartifice.primalmagick.common.research.ResearchDisciplines;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.ResearchStage;
import com.verdantartifice.primalmagick.common.research.keys.AbstractResearchKey;
import com.verdantartifice.primalmagick.common.research.keys.EntityScanKey;
import com.verdantartifice.primalmagick.common.research.keys.ItemScanKey;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ResearchManager {
    private static final Set<Integer> CRAFTING_REFERENCES = new HashSet<Integer>();
    private static final Set<UUID> SYNC_SET = ConcurrentHashMap.newKeySet();
    private static final List<IScanTrigger> SCAN_TRIGGERS = new ArrayList<IScanTrigger>();
    private static final ResearchEntryKey FIRST_STEPS = new ResearchEntryKey(ResearchEntries.FIRST_STEPS);
    private static Function<Player, List<AffinityIndexEntry>> memoizedAffinityIndexEntries = Util.memoize(ResearchManager::getAffinityIndexEntriesInner);

    public static Set<Integer> getAllCraftingReferences() {
        return Collections.unmodifiableSet(CRAFTING_REFERENCES);
    }

    public static boolean addCraftingReference(int reference) {
        return CRAFTING_REFERENCES.add(reference);
    }

    static void clearCraftingReferences() {
        CRAFTING_REFERENCES.clear();
    }

    @Nullable
    public static Optional<ResearchEntry> getEntryForRecipe(RegistryAccess registryAccess, ResourceLocation recipeId) {
        return ResearchEntries.stream(registryAccess).filter(entry -> entry.getAllRecipeIds().contains(recipeId)).findFirst();
    }

    public static boolean hasStartedProgression(Player player) {
        return FIRST_STEPS.isKnownBy(player);
    }

    public static boolean isRecipeVisible(ResourceLocation recipeId, Player player) {
        ResearchStage currentStage;
        IPlayerKnowledge know = Services.CAPABILITIES.knowledge(player).orElseThrow(() -> new IllegalStateException("No knowledge provider for player"));
        ResearchEntry entry = ResearchManager.getEntryForRecipe(player.level().registryAccess(), recipeId).orElse(null);
        if (entry == null) {
            return false;
        }
        int currentStageIndex = know.getResearchStage(entry.key());
        if (currentStageIndex == entry.stages().size() ? (currentStage = entry.stages().get(currentStageIndex - 1)).recipes().contains(recipeId) : currentStageIndex >= 0 && currentStageIndex < entry.stages().size() && (currentStage = entry.stages().get(currentStageIndex)).recipes().contains(recipeId)) {
            return true;
        }
        for (ResearchAddendum addendum : entry.addenda()) {
            if (!addendum.completionRequirementOpt().isPresent() || !addendum.recipes().contains(recipeId) || !addendum.completionRequirementOpt().get().isMetBy(player)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSyncScheduled(@Nullable Player player) {
        if (player == null) {
            return false;
        }
        return SYNC_SET.remove(player.getUUID());
    }

    public static void scheduleSync(@Nullable Player player) {
        if (player != null) {
            SYNC_SET.add(player.getUUID());
        }
    }

    public static boolean hasPrerequisites(@Nullable Player player, @Nullable AbstractResearchKey<?> key) {
        if (player == null) {
            return false;
        }
        if (key == null) {
            return true;
        }
        if (key instanceof ResearchEntryKey) {
            ResearchEntryKey entryKey = (ResearchEntryKey)key;
            Optional entryRefOpt = player.level().registryAccess().registryOrThrow(RegistryKeysPM.RESEARCH_ENTRIES).getHolder(entryKey.getRootKey());
            if (entryRefOpt.isEmpty() || ((ResearchEntry)((Holder.Reference)entryRefOpt.get()).value()).parents().isEmpty()) {
                return true;
            }
            return ((ResearchEntry)((Holder.Reference)entryRefOpt.get()).value()).parents().stream().allMatch(k -> k.isKnownBy(player));
        }
        return true;
    }

    public static boolean isResearchStarted(@Nullable Player player, @Nonnull ResourceKey<ResearchEntry> rawKey) {
        return ResearchManager.isResearchStarted(player, new ResearchEntryKey(rawKey));
    }

    public static boolean isResearchStarted(@Nullable Player player, @Nullable AbstractResearchKey<?> key) {
        if (player == null || key == null) {
            return false;
        }
        return Services.CAPABILITIES.knowledge(player).map(k -> k.isResearchKnown(key)).orElse(false);
    }

    public static boolean isResearchComplete(@Nullable Player player, @Nonnull ResourceKey<ResearchEntry> rawKey) {
        return ResearchManager.isResearchComplete(player, new ResearchEntryKey(rawKey));
    }

    public static boolean isResearchComplete(@Nullable Player player, @Nullable AbstractResearchKey<?> key) {
        if (player == null || key == null) {
            return false;
        }
        RegistryAccess registryAccess = player.level().registryAccess();
        return Services.CAPABILITIES.knowledge(player).map(k -> k.isResearchComplete(registryAccess, key)).orElse(false);
    }

    public static boolean completeResearch(@Nullable Player player, @Nonnull ResourceKey<ResearchEntry> rawKey) {
        return ResearchManager.completeResearch(player, new ResearchEntryKey(rawKey));
    }

    public static boolean completeResearch(@Nullable Player player, @Nullable AbstractResearchKey<?> key) {
        return ResearchManager.completeResearch(player, key, true);
    }

    public static boolean completeResearch(@Nullable Player player, @Nullable AbstractResearchKey<?> key, boolean sync) {
        return ResearchManager.completeResearch(player, key, sync, true, true);
    }

    public static boolean completeResearch(@Nullable Player player, @Nullable AbstractResearchKey<?> key, boolean sync, boolean showNewFlags, boolean showPopups) {
        boolean retVal = false;
        while (ResearchManager.progressResearch(player, key, sync, showNewFlags, showPopups)) {
            retVal = true;
        }
        return retVal;
    }

    public static void forceGrantWithAllParents(@Nullable Player player, @Nonnull ResourceKey<ResearchEntry> rawKey) {
        ResearchManager.forceGrantWithAllParents(player, new ResearchEntryKey(rawKey));
    }

    public static void forceGrantWithAllParents(@Nullable Player player, @Nullable ResearchEntryKey key) {
        if (player != null && key != null) {
            RegistryAccess registryAccess = player.level().registryAccess();
            Services.CAPABILITIES.knowledge(player).ifPresent(knowledge -> {
                if (!knowledge.isResearchComplete(registryAccess, key)) {
                    ResearchEntry entry = ResearchEntries.getEntry(registryAccess, key);
                    if (entry != null) {
                        entry.parents().forEach(parentKey -> ResearchManager.forceGrantWithAllParents(player, parentKey));
                        for (ResearchStage stage : entry.stages()) {
                            stage.completionRequirementOpt().ifPresent(req -> req.forceComplete(player));
                        }
                    }
                    ResearchManager.completeResearch(player, key, true, true, false);
                    registryAccess.registryOrThrow(RegistryKeysPM.RESEARCH_ENTRIES).forEach(searchEntry -> {
                        for (ResearchStage searchStage : searchEntry.stages()) {
                            if (!searchStage.completionRequirementOpt().isPresent() || !searchStage.completionRequirementOpt().get().contains(key)) continue;
                            knowledge.addResearchFlag(searchEntry.key(), IPlayerKnowledge.ResearchFlag.UPDATED);
                            knowledge.removeResearchFlag(searchEntry.key(), IPlayerKnowledge.ResearchFlag.READ);
                            break;
                        }
                    });
                }
            });
        }
    }

    public static void forceGrantParentsOnly(@Nullable Player player, @Nullable ResearchEntryKey key) {
        if (player != null && key != null) {
            RegistryAccess registryAccess = player.level().registryAccess();
            Services.CAPABILITIES.knowledge(player).ifPresent(knowledge -> {
                ResearchEntry entry;
                if (!knowledge.isResearchComplete(registryAccess, key) && (entry = ResearchEntries.getEntry(registryAccess, key)) != null) {
                    entry.parents().forEach(parentKey -> ResearchManager.forceGrantWithAllParents(player, parentKey));
                    for (ResearchStage stage : entry.stages()) {
                        stage.completionRequirementOpt().ifPresent(req -> req.forceComplete(player));
                    }
                }
            });
        }
    }

    public static void forceGrantAll(@Nullable Player player) {
        if (player != null) {
            player.level().registryAccess().registryOrThrow(RegistryKeysPM.RESEARCH_ENTRIES).forEach(entry -> ResearchManager.forceGrantWithAllParents(player, entry.key()));
        }
    }

    public static void forceRevokeWithAllChildren(@Nullable Player player, @Nonnull ResourceKey<ResearchEntry> rawKey) {
        ResearchManager.forceRevokeWithAllChildren(player, new ResearchEntryKey(rawKey));
    }

    public static void forceRevokeWithAllChildren(@Nullable Player player, @Nullable ResearchEntryKey key) {
        if (player != null && key != null) {
            RegistryAccess registryAccess = player.level().registryAccess();
            Services.CAPABILITIES.knowledge(player).ifPresent(knowledge -> {
                if (knowledge.isResearchComplete(registryAccess, key)) {
                    registryAccess.registryOrThrow(RegistryKeysPM.RESEARCH_ENTRIES).forEach(entry -> {
                        if (entry.parents().contains(key)) {
                            ResearchManager.forceRevokeWithAllChildren(player, entry.key());
                        }
                    });
                    ResearchManager.revokeResearch(player, key);
                }
            });
        }
    }

    public static boolean revokeResearch(@Nullable Player player, @Nullable ResearchEntryKey key) {
        return ResearchManager.revokeResearch(player, key, true);
    }

    public static boolean revokeResearch(@Nullable Player player, @Nullable ResearchEntryKey key, boolean sync) {
        if (player == null || key == null) {
            return false;
        }
        IPlayerKnowledge knowledge = Services.CAPABILITIES.knowledge(player).orElse(null);
        if (knowledge == null) {
            return false;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ResearchEntry entry = ResearchEntries.getEntry(player.level().registryAccess(), key);
            if (entry != null) {
                RecipeManager recipeManager = serverPlayer.level().getRecipeManager();
                Set<RecipeHolder<?>> recipesToRemove = entry.getAllRecipeIds().stream().map(r -> recipeManager.byKey(r).orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet());
                ArcaneRecipeBookManager.removeRecipes(recipesToRemove, serverPlayer);
                serverPlayer.resetRecipes(recipesToRemove);
            }
        }
        knowledge.removeResearch(key);
        if (sync) {
            ResearchManager.scheduleSync(player);
        }
        return true;
    }

    public static boolean progressResearch(@Nullable Player player, @Nonnull ResourceKey<ResearchEntry> rawKey) {
        return ResearchManager.progressResearch(player, new ResearchEntryKey(rawKey));
    }

    public static boolean progressResearch(@Nullable Player player, @Nullable ResearchEntryKey key) {
        return ResearchManager.progressResearch(player, key, true);
    }

    public static boolean progressResearch(@Nullable Player player, @Nullable ResearchEntryKey key, boolean sync) {
        return ResearchManager.progressResearch(player, key, sync, true, true);
    }

    public static boolean progressResearch(@Nullable Player player, @Nullable AbstractResearchKey<?> key, boolean sync, boolean showNewFlags, boolean showPopups) {
        ResearchEntry researchEntry;
        if (player == null || key == null) {
            return false;
        }
        RegistryAccess registryAccess = player.level().registryAccess();
        IPlayerKnowledge knowledge = Services.CAPABILITIES.knowledge(player).orElse(null);
        if (knowledge == null) {
            return false;
        }
        if (knowledge.isResearchComplete(registryAccess, key)) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggersPM.RESEARCH_COMPLETED.get().trigger(serverPlayer, key);
            }
            return false;
        }
        if (!ResearchManager.hasPrerequisites(player, key)) {
            return false;
        }
        boolean added = false;
        if (!knowledge.isResearchKnown(key)) {
            knowledge.addResearch(key);
            added = true;
        }
        if (key instanceof ResearchEntryKey) {
            ResearchEntryKey entryKey = (ResearchEntryKey)key;
            researchEntry = ResearchEntries.getEntry(registryAccess, entryKey);
        } else {
            researchEntry = null;
        }
        ResearchEntry entry = researchEntry;
        boolean entryComplete = true;
        if (entry != null && !entry.stages().isEmpty()) {
            ResearchStage currentStage = null;
            int currentStageNum = knowledge.getResearchStage(key);
            if (!added) {
                ++currentStageNum;
            }
            if (currentStageNum == entry.stages().size() - 1 && !entry.stages().get(currentStageNum).hasPrerequisites()) {
                ++currentStageNum;
            }
            if ((currentStageNum = Math.min(currentStageNum, entry.stages().size())) >= 0) {
                currentStage = entry.stages().get(Math.min(currentStageNum, entry.stages().size() - 1));
            }
            knowledge.setResearchStage(key, currentStageNum);
            boolean bl = entryComplete = currentStageNum >= entry.stages().size();
            if (currentStage != null) {
                SourceList attunements = currentStage.attunements();
                for (Source source : attunements.getSources()) {
                    int amount = attunements.getAmount(source);
                    if (amount <= 0) continue;
                    AttunementManager.incrementAttunement(player, source, AttunementType.PERMANENT, amount);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    RecipeManager recipeManager = serverPlayer.level().getRecipeManager();
                    Set<RecipeHolder<?>> recipesToUnlock = currentStage.recipes().stream().map(r -> recipeManager.byKey(r).orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet());
                    ArcaneRecipeBookManager.addRecipes(recipesToUnlock, serverPlayer);
                    serverPlayer.awardRecipes(recipesToUnlock);
                }
                for (AbstractResearchKey abstractResearchKey : currentStage.siblings()) {
                    ResearchManager.completeResearch(player, abstractResearchKey, sync);
                }
                for (ResearchEntryKey researchEntryKey : currentStage.revelations()) {
                    if (knowledge.isResearchKnown(researchEntryKey)) continue;
                    knowledge.addResearch(researchEntryKey);
                    if (showPopups) {
                        knowledge.addResearchFlag(researchEntryKey, IPlayerKnowledge.ResearchFlag.POPUP);
                    }
                    knowledge.addResearchFlag(researchEntryKey, IPlayerKnowledge.ResearchFlag.NEW);
                    knowledge.removeResearchFlag(researchEntryKey, IPlayerKnowledge.ResearchFlag.READ);
                }
                for (ResearchEntryKey researchEntryKey : currentStage.highlights()) {
                    knowledge.addResearchFlag(researchEntryKey, IPlayerKnowledge.ResearchFlag.HIGHLIGHT);
                }
            }
            if (entryComplete && !entry.addenda().isEmpty() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                RecipeManager recipeManager = serverPlayer.level().getRecipeManager();
                for (ResearchAddendum addendum : entry.addenda()) {
                    if (!addendum.completionRequirementOpt().isEmpty() && !addendum.completionRequirementOpt().get().isMetBy(player)) continue;
                    Set<RecipeHolder<?>> recipesToUnlock = addendum.recipes().stream().map(r -> recipeManager.byKey(r).orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet());
                    ArcaneRecipeBookManager.addRecipes(recipesToUnlock, serverPlayer);
                    serverPlayer.awardRecipes(recipesToUnlock);
                    for (AbstractResearchKey<?> sibling : addendum.siblings()) {
                        ResearchManager.completeResearch(player, sibling, sync);
                    }
                }
            }
            if (!added) {
                player.giveExperiencePoints(5);
            }
        }
        if (entryComplete) {
            ServerPlayer serverPlayer;
            if (sync) {
                if (showPopups) {
                    knowledge.addResearchFlag(key, IPlayerKnowledge.ResearchFlag.POPUP);
                }
                if (showNewFlags) {
                    knowledge.addResearchFlag(key, IPlayerKnowledge.ResearchFlag.NEW);
                    knowledge.removeResearchFlag(key, IPlayerKnowledge.ResearchFlag.READ);
                }
            }
            registryAccess.registryOrThrow(RegistryKeysPM.RESEARCH_ENTRIES).forEach(searchEntry -> {
                if (!searchEntry.addenda().isEmpty() && knowledge.isResearchComplete(registryAccess, searchEntry.key())) {
                    for (ResearchAddendum addendum : searchEntry.addenda()) {
                        addendum.completionRequirementOpt().filter(req -> req.contains(key) && req.isMetBy(player)).ifPresent(req -> {
                            MutableComponent nameComp = Component.translatable((String)searchEntry.getNameTranslationKey());
                            player.sendSystemMessage((Component)Component.translatable((String)"event.primalmagick.add_addendum", (Object[])new Object[]{nameComp}));
                            knowledge.addResearchFlag(searchEntry.key(), IPlayerKnowledge.ResearchFlag.UPDATED);
                            knowledge.removeResearchFlag(searchEntry.key(), IPlayerKnowledge.ResearchFlag.READ);
                            SourceList attunements = addendum.attunements();
                            for (Source source : attunements.getSources()) {
                                int amount = attunements.getAmount(source);
                                if (amount <= 0) continue;
                                AttunementManager.incrementAttunement(player, source, AttunementType.PERMANENT, amount);
                            }
                            if (player instanceof ServerPlayer) {
                                ServerPlayer serverPlayer = (ServerPlayer)player;
                                RecipeManager recipeManager = serverPlayer.level().getRecipeManager();
                                Set<RecipeHolder<?>> recipesToUnlock = addendum.recipes().stream().map(r -> recipeManager.byKey(r).orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet());
                                ArcaneRecipeBookManager.addRecipes(recipesToUnlock, serverPlayer);
                                serverPlayer.awardRecipes(recipesToUnlock);
                            }
                            for (AbstractResearchKey abstractResearchKey : addendum.siblings()) {
                                ResearchManager.completeResearch(player, abstractResearchKey, sync);
                            }
                        });
                    }
                }
            });
            if (entry != null && player instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)player;
                ResearchDisciplines.streamIndexDisciplines(registryAccess).filter(d -> d.unlockRequirementOpt().map(req -> req.satisfiedBy(entry.key())).orElse(false)).forEach(d -> PacketHandler.sendToPlayer(new UnlockDisciplinePacket((ResearchDiscipline)d), serverPlayer));
            }
            if (entry != null) {
                entry.disciplineKeyOpt().ifPresent(disciplineKey -> {
                    ResearchDiscipline discipline = (ResearchDiscipline)registryAccess.registryOrThrow(RegistryKeysPM.RESEARCH_DISCIPLINES).get(disciplineKey.getRootKey());
                    if (discipline != null) {
                        for (ResearchEntry finaleEntry : discipline.getFinaleEntries(registryAccess)) {
                            boolean shouldUnlock;
                            ResearchEntryKey finaleKey = finaleEntry.key();
                            if (knowledge.isResearchKnown(finaleKey) || !(shouldUnlock = finaleEntry.finales().stream().map(k -> (ResearchDiscipline)registryAccess.registryOrThrow(RegistryKeysPM.RESEARCH_DISCIPLINES).get(k.getRootKey())).filter(Objects::nonNull).flatMap(d -> d.getEntryStream(registryAccess)).filter(e -> e.finales().isEmpty() && !e.flags().finaleExempt()).allMatch(e -> e.isComplete(player)))) continue;
                            knowledge.addResearch(finaleKey);
                            if (showPopups) {
                                knowledge.addResearchFlag(finaleKey, IPlayerKnowledge.ResearchFlag.POPUP);
                            }
                            knowledge.addResearchFlag(finaleKey, IPlayerKnowledge.ResearchFlag.NEW);
                            knowledge.removeResearchFlag(finaleKey, IPlayerKnowledge.ResearchFlag.READ);
                        }
                    }
                });
            }
            if (player instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)player;
                CriteriaTriggersPM.RESEARCH_COMPLETED.get().trigger(serverPlayer, key);
            }
        }
        if (sync) {
            ResearchManager.scheduleSync(player);
        }
        return true;
    }

    public static boolean addKnowledge(Player player, KnowledgeType type, int points) {
        return ResearchManager.addKnowledge(player, type, points, true);
    }

    public static boolean addKnowledge(Player player, KnowledgeType type, int points, boolean scheduleSync) {
        IPlayerKnowledge knowledge = Services.CAPABILITIES.knowledge(player).orElse(null);
        if (knowledge == null) {
            return false;
        }
        int levelsBefore = knowledge.getKnowledge(type);
        boolean success = knowledge.addKnowledge(type, points);
        if (!success) {
            return false;
        }
        if (points > 0) {
            int levelsAfter = knowledge.getKnowledge(type);
            int delta = levelsAfter - levelsBefore;
            if (type == KnowledgeType.OBSERVATION) {
                StatsManager.incrementValue(player, StatsPM.OBSERVATIONS_MADE, delta);
            } else if (type == KnowledgeType.THEORY) {
                StatsManager.incrementValue(player, StatsPM.THEORIES_FORMED, delta);
            }
            for (int index = 0; index < delta; ++index) {
            }
        }
        if (scheduleSync) {
            ResearchManager.scheduleSync(player);
        }
        return true;
    }

    public static boolean registerScanTrigger(@Nullable IScanTrigger trigger) {
        if (trigger == null) {
            return false;
        }
        return SCAN_TRIGGERS.add(trigger);
    }

    public static void checkScanTriggers(ServerPlayer player, ItemLike itemProvider) {
        ResearchManager.checkScanTriggersInner(player, itemProvider);
    }

    public static void checkScanTriggers(ServerPlayer player, EntityType<?> entityType) {
        ResearchManager.checkScanTriggersInner(player, entityType);
    }

    private static void checkScanTriggersInner(ServerPlayer player, Object obj) {
        for (IScanTrigger trigger : SCAN_TRIGGERS) {
            if (!trigger.matches(player, obj)) continue;
            trigger.onMatch(player, obj);
        }
    }

    public static boolean hasScanTriggers(ServerPlayer player, ItemLike itemProvider) {
        return ResearchManager.hasScanTriggersInner(player, itemProvider);
    }

    public static boolean hasScanTriggers(ServerPlayer player, EntityType<?> entityType) {
        return ResearchManager.hasScanTriggersInner(player, entityType);
    }

    private static boolean hasScanTriggersInner(ServerPlayer player, Object obj) {
        for (IScanTrigger trigger : SCAN_TRIGGERS) {
            if (!trigger.matches(player, obj)) continue;
            return true;
        }
        return false;
    }

    public static boolean isScanned(@Nullable ItemStack stack, @Nullable Player player) {
        if (stack == null || stack.isEmpty() || player == null) {
            return false;
        }
        Optional<SourceList> affinitiesOpt = AffinityManager.getInstance().getAffinityValues(stack, player.level());
        if (affinitiesOpt.isPresent()) {
            SourceList affinities = affinitiesOpt.get();
            if (!(affinities != null && !affinities.isEmpty() || player instanceof ServerPlayer && ResearchManager.hasScanTriggers((ServerPlayer)player, (ItemLike)stack.getItem()))) {
                return true;
            }
            return new ItemScanKey(stack).isKnownBy(player);
        }
        return true;
    }

    public static CompletableFuture<Boolean> isScannedAsync(@Nullable ItemStack stack, @Nullable Player player) {
        if (stack == null || stack.isEmpty() || player == null) {
            return CompletableFuture.completedFuture(Boolean.FALSE);
        }
        return AffinityManager.getInstance().getAffinityValuesAsync(stack, player.level()).thenApply(affinities -> {
            if (!(affinities != null && !affinities.isEmpty() || player instanceof ServerPlayer && ResearchManager.hasScanTriggers((ServerPlayer)player, (ItemLike)stack.getItem()))) {
                return true;
            }
            return new ItemScanKey(stack).isKnownBy(player);
        });
    }

    public static boolean isScanned(@Nullable EntityType<?> type, @Nullable Player player) {
        if (type == null || player == null) {
            return false;
        }
        Optional<SourceList> affinitiesOpt = AffinityManager.getInstance().getAffinityValues(type, player.level().registryAccess());
        if (affinitiesOpt.isPresent()) {
            SourceList affinities = affinitiesOpt.get();
            if (!(affinities != null && !affinities.isEmpty() || player instanceof ServerPlayer && ResearchManager.hasScanTriggers((ServerPlayer)player, type))) {
                return true;
            }
            return new EntityScanKey(type).isKnownBy(player);
        }
        return true;
    }

    public static CompletableFuture<Boolean> isScannedAsync(@Nullable EntityType<?> type, @Nullable Player player) {
        if (type == null || player == null) {
            return CompletableFuture.completedFuture(Boolean.FALSE);
        }
        return AffinityManager.getInstance().getAffinityValuesAsync(type, player.level().registryAccess()).thenApply(affinities -> {
            if (!(affinities != null && !affinities.isEmpty() || player instanceof ServerPlayer && ResearchManager.hasScanTriggers((ServerPlayer)player, type))) {
                return true;
            }
            return new EntityScanKey(type).isKnownBy(player);
        });
    }

    public static boolean setScanned(@Nullable ItemStack stack, @Nullable ServerPlayer player) {
        return ResearchManager.setScanned(stack, player, true);
    }

    public static boolean setScanned(@Nullable ItemStack stack, @Nullable ServerPlayer player, boolean sync) {
        if (stack == null || stack.isEmpty() || player == null) {
            return false;
        }
        IPlayerKnowledge knowledge = Services.CAPABILITIES.knowledge((Player)player).orElse(null);
        if (knowledge == null) {
            return false;
        }
        ResearchManager.checkScanTriggers(player, (ItemLike)stack.getItem());
        ItemScanKey key = new ItemScanKey(stack);
        if (key != null && knowledge.addResearch(key)) {
            ResearchManager.getObservationPointsAsync(stack, player.getCommandSenderWorld()).thenAccept(obsPoints -> {
                if (obsPoints > 0) {
                    ResearchManager.addKnowledge((Player)player, KnowledgeType.OBSERVATION, obsPoints, false);
                }
            });
            StatsManager.incrementValue((Player)player, StatsPM.ITEMS_ANALYZED);
            if (sync) {
                knowledge.sync(player);
            }
            ResearchManager.invalidateAffinityIndexEntries();
            return true;
        }
        return false;
    }

    public static boolean setScanned(@Nullable EntityType<?> type, @Nullable ServerPlayer player) {
        return ResearchManager.setScanned(type, player, true);
    }

    public static boolean setScanned(@Nullable EntityType<?> type, @Nullable ServerPlayer player, boolean sync) {
        if (type == null || player == null) {
            return false;
        }
        IPlayerKnowledge knowledge = Services.CAPABILITIES.knowledge((Player)player).orElse(null);
        if (knowledge == null) {
            return false;
        }
        EntityScanKey key = new EntityScanKey(type);
        if (key != null && knowledge.addResearch(key)) {
            ResearchManager.getObservationPointsAsync(type, player.getCommandSenderWorld()).thenAccept(obsPoints -> {
                if (obsPoints > 0) {
                    ResearchManager.addKnowledge((Player)player, KnowledgeType.OBSERVATION, obsPoints, false);
                }
            });
            StatsManager.incrementValue((Player)player, StatsPM.ENTITIES_ANALYZED);
            ResearchManager.checkScanTriggers(player, type);
            if (sync) {
                knowledge.sync(player);
            }
            return true;
        }
        return false;
    }

    public static int setAllScanned(@Nullable ServerPlayer player) {
        if (player == null) {
            return 0;
        }
        IPlayerKnowledge knowledge = Services.CAPABILITIES.knowledge((Player)player).orElse(null);
        if (knowledge == null) {
            return 0;
        }
        int count = 0;
        ArrayList<CompletableFuture<Integer>> obsPointsFutures = new ArrayList<CompletableFuture<Integer>>();
        for (Item item : Services.ITEMS_REGISTRY.getAll()) {
            ItemScanKey key;
            ItemStack stack = new ItemStack((ItemLike)item);
            if (stack.isEmpty() || (key = new ItemScanKey(stack)) == null || !knowledge.addResearch(key)) continue;
            ++count;
            obsPointsFutures.add(ResearchManager.getObservationPointsAsync(stack, player.getCommandSenderWorld()));
            ResearchManager.checkScanTriggers(player, (ItemLike)item);
        }
        Util.sequence(obsPointsFutures).thenAccept(obsPointsList -> {
            int obsPoints = obsPointsList.stream().mapToInt(i -> i).sum();
            if (obsPoints > 0) {
                ResearchManager.addKnowledge((Player)player, KnowledgeType.OBSERVATION, obsPoints, false);
            }
        });
        if (count > 0) {
            knowledge.sync(player);
        }
        ResearchManager.invalidateAffinityIndexEntries();
        return count;
    }

    private static CompletableFuture<Integer> getObservationPointsAsync(@Nonnull ItemStack stack, @Nonnull Level world) {
        return AffinityManager.getInstance().getAffinityValuesAsync(stack, world).thenApply(ResearchManager::getObservationPoints);
    }

    private static CompletableFuture<Integer> getObservationPointsAsync(@Nonnull EntityType<?> type, @Nonnull Level level) {
        return AffinityManager.getInstance().getAffinityValuesAsync(type, level.registryAccess()).thenApply(ResearchManager::getObservationPoints);
    }

    private static int getObservationPoints(@Nullable SourceList affinities) {
        if (affinities == null || affinities.isEmpty()) {
            return 0;
        }
        double total = 0.0;
        for (Source source : affinities.getSources()) {
            total += (double)affinities.getAmount(source) * source.getObservationMultiplier();
        }
        if (total > 0.0) {
            total = Math.sqrt(total);
        }
        return Mth.ceil((double)total);
    }

    public static List<AffinityIndexEntry> getAffinityIndexEntries(Player player) {
        return memoizedAffinityIndexEntries.apply(player);
    }

    private static List<AffinityIndexEntry> getAffinityIndexEntriesInner(Player player) {
        Level level = player.level();
        return Services.CAPABILITIES.knowledge(player).map(knowledge -> knowledge.getResearchSet().stream().map(k -> {
            ItemScanKey scanKey;
            return k instanceof ItemScanKey ? (scanKey = (ItemScanKey)k) : null;
        }).filter(Objects::nonNull).map(k -> new AffinityIndexEntry(k.getStack(), AffinityManager.getInstance().getAffinityValuesAsync(k.getStack(), level))).toList()).orElseGet(List::of);
    }

    private static void invalidateAffinityIndexEntries() {
        memoizedAffinityIndexEntries = Util.memoize(ResearchManager::getAffinityIndexEntriesInner);
    }
}

