/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerKnowledge;
import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import com.verdantartifice.primalmagick.common.research.IconDefinition;
import com.verdantartifice.primalmagick.common.research.ResearchAddendum;
import com.verdantartifice.primalmagick.common.research.ResearchDiscipline;
import com.verdantartifice.primalmagick.common.research.ResearchStage;
import com.verdantartifice.primalmagick.common.research.ResearchTier;
import com.verdantartifice.primalmagick.common.research.keys.ResearchDisciplineKey;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.tags.ResearchEntryTagsPM;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.common.util.StreamCodecUtils;
import com.verdantartifice.primalmagick.platform.Services;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;

public record ResearchEntry(ResearchEntryKey key, Optional<ResearchDisciplineKey> disciplineKeyOpt, Optional<ResearchTier> tierOpt, Optional<String> nameKeyOpt, Optional<IconDefinition> iconOpt, List<ResearchEntryKey> parents, Flags flags, List<ResearchDisciplineKey> finales, List<ResearchStage> stages, List<ResearchAddendum> addenda) {
    public static Codec<ResearchEntry> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)ResearchEntryKey.CODEC.fieldOf("key").forGetter(ResearchEntry::key), (App)ResearchDisciplineKey.CODEC.codec().optionalFieldOf("disciplineKey").forGetter(ResearchEntry::disciplineKeyOpt), (App)ResearchTier.CODEC.optionalFieldOf("tier").forGetter(ResearchEntry::tierOpt), (App)Codec.STRING.optionalFieldOf("nameKey").forGetter(ResearchEntry::nameKeyOpt), (App)IconDefinition.CODEC.optionalFieldOf("icon").forGetter(ResearchEntry::iconOpt), (App)ResearchEntryKey.CODEC.codec().listOf().fieldOf("parents").forGetter(ResearchEntry::parents), (App)Flags.CODEC.fieldOf("flags").forGetter(ResearchEntry::flags), (App)ResearchDisciplineKey.CODEC.codec().listOf().fieldOf("finales").forGetter(ResearchEntry::finales), (App)ResearchStage.codec().listOf().fieldOf("stages").forGetter(ResearchEntry::stages), (App)ResearchAddendum.codec().listOf().fieldOf("addenda").forGetter(ResearchEntry::addenda)).apply((Applicative)instance, ResearchEntry::new));
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ResearchEntry> streamCodec() {
        return StreamCodecUtils.composite(ResearchEntryKey.STREAM_CODEC, ResearchEntry::key, ByteBufCodecs.optional(ResearchDisciplineKey.STREAM_CODEC), ResearchEntry::disciplineKeyOpt, ByteBufCodecs.optional(ResearchTier.STREAM_CODEC), ResearchEntry::tierOpt, ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), ResearchEntry::nameKeyOpt, ByteBufCodecs.optional(IconDefinition.STREAM_CODEC), ResearchEntry::iconOpt, ResearchEntryKey.STREAM_CODEC.apply(ByteBufCodecs.list()), ResearchEntry::parents, Flags.STREAM_CODEC, ResearchEntry::flags, ResearchDisciplineKey.STREAM_CODEC.apply(ByteBufCodecs.list()), ResearchEntry::finales, ResearchStage.streamCodec().apply(ByteBufCodecs.list()), ResearchEntry::stages, ResearchAddendum.streamCodec().apply(ByteBufCodecs.list()), ResearchEntry::addenda, ResearchEntry::new);
    }

    public static Builder builder(ResourceKey<ResearchEntry> key) {
        return new Builder(key);
    }

    public String getBaseTranslationKey() {
        return String.join((CharSequence)".", "research", this.key.getRootKey().location().getNamespace(), this.key.getRootKey().location().getPath());
    }

    public String getNameTranslationKey() {
        return this.nameKeyOpt().orElseGet(() -> String.join((CharSequence)".", this.getBaseTranslationKey(), "title"));
    }

    public Optional<String> getHintTranslationKey() {
        if (this.flags().hasHint()) {
            return Optional.of(String.join((CharSequence)".", this.getBaseTranslationKey(), "hint"));
        }
        return Optional.empty();
    }

    public boolean isForDiscipline(ResearchDisciplineKey discipline) {
        return this.disciplineKeyOpt.isPresent() && this.disciplineKeyOpt.get().equals(discipline);
    }

    public boolean isFinaleFor(ResearchDisciplineKey discipline) {
        return this.finales.contains(discipline);
    }

    public boolean isFinaleFor(ResourceKey<ResearchDiscipline> discipline) {
        return this.isFinaleFor(new ResearchDisciplineKey(discipline));
    }

    private IPlayerKnowledge getKnowledge(@Nonnull Player player) {
        return Services.CAPABILITIES.knowledge(player).orElseThrow(() -> new IllegalStateException("No knowledge provider for player"));
    }

    public boolean isNew(@Nonnull Player player) {
        return this.getKnowledge(player).hasResearchFlag(this.key(), IPlayerKnowledge.ResearchFlag.NEW);
    }

    public boolean isUpdated(@Nonnull Player player) {
        return this.getKnowledge(player).hasResearchFlag(this.key(), IPlayerKnowledge.ResearchFlag.UPDATED);
    }

    public boolean isHighlighted(@Nonnull Player player) {
        return this.getKnowledge(player).hasResearchFlag(this.key(), IPlayerKnowledge.ResearchFlag.HIGHLIGHT);
    }

    public boolean isUnread(@Nonnull Player player) {
        return !this.getKnowledge(player).hasResearchFlag(this.key(), IPlayerKnowledge.ResearchFlag.READ) && this.isAvailable(player) && (!this.flags().hidden() || this.getKnowledge(player).getResearchStage(this.key()) >= 0);
    }

    public void markRead(@Nonnull Player player) {
        this.getKnowledge(player).addResearchFlag(this.key(), IPlayerKnowledge.ResearchFlag.READ);
        this.getKnowledge(player).removeResearchFlag(this.key(), IPlayerKnowledge.ResearchFlag.NEW);
        this.getKnowledge(player).removeResearchFlag(this.key(), IPlayerKnowledge.ResearchFlag.UPDATED);
        this.getKnowledge(player).removeResearchFlag(this.key(), IPlayerKnowledge.ResearchFlag.HIGHLIGHT);
    }

    public boolean isReadByDefault(@Nonnull Player player) {
        return !this.isAvailable(player) || !this.isNew(player) && !this.isUpdated(player) && !this.isUnknown(player);
    }

    public boolean isComplete(@Nonnull Player player) {
        return this.getKnowledge(player).getResearchStatus(player.level().registryAccess(), this.key()) == IPlayerKnowledge.ResearchStatus.COMPLETE;
    }

    public boolean isInProgress(@Nonnull Player player) {
        return this.getKnowledge(player).getResearchStatus(player.level().registryAccess(), this.key()) == IPlayerKnowledge.ResearchStatus.IN_PROGRESS;
    }

    public boolean isAvailable(@Nonnull Player player) {
        return this.parents.isEmpty() || this.parents.stream().allMatch(key -> key.isKnownBy(player));
    }

    public boolean isUpcoming(@Nonnull Player player) {
        Registry registry = player.level().registryAccess().registryOrThrow(RegistryKeysPM.RESEARCH_ENTRIES);
        return !this.parents.stream().map(k -> registry.getHolder(k.getRootKey())).anyMatch(opt -> opt.isPresent() && (((Holder.Reference)opt.get()).is(ResearchEntryTagsPM.OPAQUE) && !((ResearchEntry)((Holder.Reference)opt.get()).value()).key().isKnownBy(player) || !((ResearchEntry)((Holder.Reference)opt.get()).value()).isAvailable(player)));
    }

    public boolean isVisible(@Nonnull Player player) {
        return this.isAvailable(player) || this.isUpcoming(player);
    }

    public boolean isUnknown(@Nonnull Player player) {
        return this.getKnowledge(player).getResearchStatus(player.registryAccess(), this.key()) == IPlayerKnowledge.ResearchStatus.UNKNOWN;
    }

    @Nonnull
    public Set<ResourceLocation> getAllRecipeIds() {
        return Stream.concat(this.stages.stream().flatMap(stage -> stage.recipes().stream()), this.addenda.stream().flatMap(addendum -> addendum.recipes().stream())).collect(Collectors.toSet());
    }

    @Nonnull
    public Set<ResourceLocation> getKnownRecipeIds(Player player) {
        boolean entryComplete;
        HashSet<ResourceLocation> retVal = new HashSet<ResourceLocation>();
        if (this.stages().isEmpty()) {
            return retVal;
        }
        IPlayerKnowledge knowledge = this.getKnowledge(player);
        RegistryAccess registryAccess = player.level().registryAccess();
        ResearchStage currentStage = null;
        int currentStageNum = knowledge.getResearchStage(this.key);
        if (currentStageNum >= 0) {
            currentStage = this.stages().get(Math.min(currentStageNum, this.stages().size() - 1));
        }
        boolean bl = entryComplete = currentStageNum >= this.stages().size();
        if (currentStage != null) {
            retVal.addAll(currentStage.recipes());
        }
        if (entryComplete) {
            for (ResearchAddendum addendum : this.addenda()) {
                addendum.completionRequirementOpt().ifPresent(req -> {
                    if (req.isMetBy(player)) {
                        retVal.addAll(addendum.recipes());
                    }
                });
            }
            registryAccess.registryOrThrow(RegistryKeysPM.RESEARCH_ENTRIES).forEach(searchEntry -> {
                if (!searchEntry.addenda().isEmpty() && knowledge.isResearchComplete(registryAccess, searchEntry.key())) {
                    for (ResearchAddendum addendum : searchEntry.addenda()) {
                        addendum.completionRequirementOpt().ifPresent(req -> {
                            if (req.contains(this.key) && req.isMetBy(player)) {
                                retVal.addAll(addendum.recipes());
                            }
                        });
                    }
                }
            });
        }
        return retVal;
    }

    public record Flags(boolean hidden, boolean hasHint, boolean internal, boolean finaleExempt) {
        public static final Flags EMPTY = new Flags(false, false, false, false);
        public static final Codec<Flags> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("hidden", (Object)false).forGetter(Flags::hidden), (App)Codec.BOOL.optionalFieldOf("hasHint", (Object)false).forGetter(Flags::hasHint), (App)Codec.BOOL.optionalFieldOf("internal", (Object)false).forGetter(Flags::internal), (App)Codec.BOOL.optionalFieldOf("finaleExempt", (Object)false).forGetter(Flags::finaleExempt)).apply((Applicative)instance, Flags::new));
        public static final StreamCodec<ByteBuf, Flags> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, Flags::hidden, (StreamCodec)ByteBufCodecs.BOOL, Flags::hasHint, (StreamCodec)ByteBufCodecs.BOOL, Flags::internal, (StreamCodec)ByteBufCodecs.BOOL, Flags::finaleExempt, Flags::new);

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            protected boolean hidden = false;
            protected boolean hasHint = false;
            protected boolean internal = false;
            protected boolean finaleExempt = false;

            public Builder hidden() {
                this.hidden = true;
                return this;
            }

            public Builder hasHint() {
                this.hasHint = true;
                return this;
            }

            public Builder internal() {
                this.internal = true;
                return this;
            }

            public Builder finaleExempt() {
                this.finaleExempt = true;
                return this;
            }

            public Flags build() {
                return new Flags(this.hidden, this.hasHint, this.internal, this.finaleExempt);
            }
        }
    }

    public static class Builder {
        protected final String modId;
        protected final ResearchEntryKey key;
        protected Optional<ResearchDisciplineKey> disciplineKeyOpt = Optional.empty();
        protected Optional<ResearchTier> tierOpt = Optional.empty();
        protected Optional<String> nameKeyOpt = Optional.empty();
        protected Optional<IconDefinition> iconOpt = Optional.empty();
        protected final List<ResearchEntryKey> parents = new ArrayList<ResearchEntryKey>();
        protected Flags.Builder flagsBuilder = Flags.builder();
        protected final List<ResearchDisciplineKey> finales = new ArrayList<ResearchDisciplineKey>();
        protected final List<ResearchStage.Builder> stageBuilders = new ArrayList<ResearchStage.Builder>();
        protected final List<ResearchAddendum.Builder> addendumBuilders = new ArrayList<ResearchAddendum.Builder>();

        public Builder(String modId, ResearchEntryKey key) {
            this.modId = (String)Preconditions.checkNotNull((Object)modId);
            this.key = (ResearchEntryKey)Preconditions.checkNotNull((Object)key);
        }

        public Builder(String modId, ResourceKey<ResearchEntry> rawKey) {
            this(modId, new ResearchEntryKey(rawKey));
        }

        public Builder(ResearchEntryKey key) {
            this("primalmagick", key);
        }

        public Builder(ResourceKey<ResearchEntry> rawKey) {
            this(new ResearchEntryKey(rawKey));
        }

        public Builder discipline(ResourceKey<ResearchDiscipline> discKey) {
            this.disciplineKeyOpt = Optional.of(new ResearchDisciplineKey(discKey));
            return this;
        }

        public Builder tier(ResearchTier tier) {
            this.tierOpt = Optional.ofNullable(tier);
            return this;
        }

        public Builder nameKey(String key) {
            this.nameKeyOpt = Optional.ofNullable(key);
            return this;
        }

        public Builder icon(ItemLike item) {
            this.iconOpt = Optional.of(IconDefinition.of(item));
            return this;
        }

        public Builder icon(ResourceLocation loc) {
            this.iconOpt = Optional.of(IconDefinition.of(loc));
            return this;
        }

        public Builder icon(String path) {
            return this.icon(ResourceUtils.loc(path));
        }

        public Builder parent(ResearchEntryKey key) {
            this.parents.add(key);
            return this;
        }

        public Builder parent(ResourceKey<ResearchEntry> rawKey) {
            return this.parent(new ResearchEntryKey(rawKey));
        }

        public Builder flags(Flags.Builder flagsBuilder) {
            this.flagsBuilder = flagsBuilder;
            return this;
        }

        public Builder finale(ResourceKey<ResearchDiscipline> discKey) {
            this.finales.add(new ResearchDisciplineKey(discKey));
            return this;
        }

        public ResearchStage.Builder stage() {
            ResearchStage.Builder retVal = new ResearchStage.Builder(this.modId, this, this.key, this.stageBuilders.size() + 1);
            this.stageBuilders.add(retVal);
            return retVal;
        }

        public ResearchAddendum.Builder addendum() {
            ResearchAddendum.Builder retVal = new ResearchAddendum.Builder(this.modId, this, this.key, this.addendumBuilders.size() + 1);
            this.addendumBuilders.add(retVal);
            return retVal;
        }

        private void validate() {
            if (this.modId.isBlank()) {
                throw new IllegalStateException("No mod ID specified for entry");
            }
            if (!this.flagsBuilder.internal && this.disciplineKeyOpt.isEmpty()) {
                throw new IllegalStateException("No discipline specified for non-internal entry");
            }
            if (!this.flagsBuilder.internal && this.stageBuilders.isEmpty()) {
                throw new IllegalStateException("Non-internal entries must have at least one stage");
            }
        }

        public ResearchEntry build() {
            this.validate();
            return new ResearchEntry(this.key, this.disciplineKeyOpt, this.tierOpt, this.nameKeyOpt, this.iconOpt, this.parents, this.flagsBuilder.build(), this.finales, this.stageBuilders.stream().map(b -> b.build()).toList(), this.addendumBuilders.stream().map(b -> b.build()).toList());
        }
    }
}

