/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research;

import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import com.verdantartifice.primalmagick.common.research.ResearchDiscipline;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.keys.ResearchDisciplineKey;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.util.Comparator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class ResearchDisciplines {
    public static final ResourceKey<ResearchDiscipline> BASICS = ResearchDisciplines.create("basics");
    public static final ResourceKey<ResearchDiscipline> MANAWEAVING = ResearchDisciplines.create("manaweaving");
    public static final ResourceKey<ResearchDiscipline> ALCHEMY = ResearchDisciplines.create("alchemy");
    public static final ResourceKey<ResearchDiscipline> SORCERY = ResearchDisciplines.create("sorcery");
    public static final ResourceKey<ResearchDiscipline> RUNEWORKING = ResearchDisciplines.create("runeworking");
    public static final ResourceKey<ResearchDiscipline> RITUAL = ResearchDisciplines.create("ritual");
    public static final ResourceKey<ResearchDiscipline> MAGITECH = ResearchDisciplines.create("magitech");
    public static final ResourceKey<ResearchDiscipline> SCANS = ResearchDisciplines.create("scans");

    public static ResourceKey<ResearchDiscipline> create(String name) {
        return ResourceKey.create(RegistryKeysPM.RESEARCH_DISCIPLINES, (ResourceLocation)ResourceUtils.loc(name));
    }

    public static void bootstrap(BootstrapContext<ResearchDiscipline> context) {
        context.register(BASICS, (Object)ResearchDiscipline.builder(BASICS).icon(ResourceUtils.loc("textures/item/grimoire.png")).indexSortOrder(100).build());
        context.register(MANAWEAVING, (Object)ResearchDiscipline.builder(MANAWEAVING).unlock(ResearchEntries.UNLOCK_MANAWEAVING).icon(ResourceUtils.loc("textures/research/discipline_manaweaving.png")).craftingStat(StatsPM.CRAFTED_MANAWEAVING).expertiseStat(StatsPM.EXPERTISE_MANAWEAVING).indexSortOrder(200).build());
        context.register(ALCHEMY, (Object)ResearchDiscipline.builder(ALCHEMY).unlock(ResearchEntries.UNLOCK_ALCHEMY).icon(ResourceUtils.loc("textures/research/discipline_alchemy.png")).craftingStat(StatsPM.CRAFTED_ALCHEMY).expertiseStat(StatsPM.EXPERTISE_ALCHEMY).indexSortOrder(300).build());
        context.register(SORCERY, (Object)ResearchDiscipline.builder(SORCERY).unlock(ResearchEntries.UNLOCK_SORCERY).icon(ResourceUtils.loc("textures/research/discipline_sorcery.png")).craftingStat(StatsPM.CRAFTED_SORCERY).expertiseStat(StatsPM.EXPERTISE_SORCERY).indexSortOrder(400).build());
        context.register(RUNEWORKING, (Object)ResearchDiscipline.builder(RUNEWORKING).unlock(ResearchEntries.UNLOCK_RUNEWORKING).icon(ResourceUtils.loc("textures/research/discipline_runeworking.png")).craftingStat(StatsPM.CRAFTED_RUNEWORKING).expertiseStat(StatsPM.EXPERTISE_RUNEWORKING).indexSortOrder(500).build());
        context.register(RITUAL, (Object)ResearchDiscipline.builder(RITUAL).unlock(ResearchEntries.UNLOCK_RITUAL).icon(ResourceUtils.loc("textures/research/discipline_ritual.png")).craftingStat(StatsPM.CRAFTED_RITUAL).expertiseStat(StatsPM.EXPERTISE_RITUAL).indexSortOrder(600).build());
        context.register(MAGITECH, (Object)ResearchDiscipline.builder(MAGITECH).unlock(ResearchEntries.UNLOCK_MAGITECH).icon(ResourceUtils.loc("textures/research/discipline_magitech.png")).craftingStat(StatsPM.CRAFTED_MAGITECH).expertiseStat(StatsPM.EXPERTISE_MAGITECH).indexSortOrder(700).build());
        context.register(SCANS, (Object)ResearchDiscipline.builder(SCANS).unlock(ResearchEntries.UNLOCK_SCANS).icon(ResourceUtils.loc("textures/item/magnifying_glass.png")).build());
    }

    @Nullable
    public static ResearchDiscipline getDiscipline(RegistryAccess registryAccess, ResearchDisciplineKey key) {
        return ResearchDisciplines.getDiscipline(registryAccess, key.getRootKey());
    }

    @Nullable
    public static ResearchDiscipline getDiscipline(RegistryAccess registryAccess, ResourceKey<ResearchDiscipline> rawKey) {
        return (ResearchDiscipline)registryAccess.registryOrThrow(RegistryKeysPM.RESEARCH_DISCIPLINES).get(rawKey);
    }

    public static Stream<ResearchDiscipline> stream(RegistryAccess registryAccess) {
        return registryAccess.registryOrThrow(RegistryKeysPM.RESEARCH_DISCIPLINES).stream();
    }

    public static Stream<ResearchDiscipline> streamIndexDisciplines(RegistryAccess registryAccess) {
        return registryAccess.registryOrThrow(RegistryKeysPM.RESEARCH_DISCIPLINES).stream().filter(d -> d.indexSortOrder().isPresent()).sorted(Comparator.comparingInt(a -> a.indexSortOrder().getAsInt()));
    }
}

