/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.research.KnowledgeType;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.keys.AbstractResearchKey;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.research.keys.RuneEnchantmentKey;
import com.verdantartifice.primalmagick.common.research.keys.StackCraftedKey;
import com.verdantartifice.primalmagick.common.research.keys.TagCraftedKey;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.AndRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ItemStackRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ItemTagRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.KnowledgeRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ResearchRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.StatRequirement;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.stats.Stat;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;

public record ResearchAddendum(ResearchEntryKey parentKey, String textTranslationKey, Optional<AbstractRequirement<?>> completionRequirementOpt, List<ResourceLocation> recipes, List<AbstractResearchKey<?>> siblings, SourceList attunements) {
    public static Codec<ResearchAddendum> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)ResearchEntryKey.CODEC.fieldOf("parentKey").forGetter(ResearchAddendum::parentKey), (App)Codec.STRING.fieldOf("textTranslationKey").forGetter(ResearchAddendum::textTranslationKey), (App)AbstractRequirement.dispatchCodec().optionalFieldOf("completionRequirementOpt").forGetter(ResearchAddendum::completionRequirementOpt), (App)ResourceLocation.CODEC.listOf().fieldOf("recipes").forGetter(ResearchAddendum::recipes), (App)AbstractResearchKey.dispatchCodec().listOf().fieldOf("siblings").forGetter(ResearchAddendum::siblings), (App)SourceList.CODEC.optionalFieldOf("attunements", (Object)SourceList.EMPTY).forGetter(ResearchAddendum::attunements)).apply((Applicative)instance, ResearchAddendum::new));
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ResearchAddendum> streamCodec() {
        return StreamCodec.composite(ResearchEntryKey.STREAM_CODEC, ResearchAddendum::parentKey, (StreamCodec)ByteBufCodecs.STRING_UTF8, ResearchAddendum::textTranslationKey, (StreamCodec)ByteBufCodecs.optional(AbstractRequirement.dispatchStreamCodec()), ResearchAddendum::completionRequirementOpt, (StreamCodec)ResourceLocation.STREAM_CODEC.apply(ByteBufCodecs.list()), ResearchAddendum::recipes, (StreamCodec)AbstractResearchKey.dispatchStreamCodec().apply(ByteBufCodecs.list()), ResearchAddendum::siblings, SourceList.STREAM_CODEC, ResearchAddendum::attunements, ResearchAddendum::new);
    }

    public static class Builder {
        protected final String modId;
        protected final ResearchEntry.Builder entryBuilder;
        protected final ResearchEntryKey parentKey;
        protected final int addendumIndex;
        protected final List<ResourceLocation> recipes = new ArrayList<ResourceLocation>();
        protected final List<AbstractResearchKey<?>> siblings = new ArrayList();
        protected final List<AbstractRequirement<?>> requirements = new ArrayList();
        protected final SourceList.Builder attunements = SourceList.builder();

        public Builder(String modId, ResearchEntry.Builder entryBuilder, ResearchEntryKey parentKey, int addendumIndex) {
            this.modId = (String)Preconditions.checkNotNull((Object)modId);
            this.entryBuilder = (ResearchEntry.Builder)Preconditions.checkNotNull((Object)entryBuilder);
            this.parentKey = (ResearchEntryKey)Preconditions.checkNotNull((Object)parentKey);
            this.addendumIndex = addendumIndex;
        }

        public Builder(ResearchEntry.Builder entryBuilder, ResearchEntryKey parentKey, int addendumIndex) {
            this("primalmagick", entryBuilder, parentKey, addendumIndex);
        }

        public Builder recipe(String name) {
            return this.recipe(ResourceUtils.loc(name));
        }

        public Builder recipe(String modId, String name) {
            return this.recipe(ResourceLocation.fromNamespaceAndPath((String)modId, (String)name));
        }

        public Builder recipe(ItemLike itemLike) {
            return this.recipe(Services.ITEMS_REGISTRY.getKey(itemLike.asItem()));
        }

        public Builder recipe(ResourceLocation recipe) {
            this.recipes.add(recipe);
            return this;
        }

        public Builder siblingResearch(ResourceKey<ResearchEntry> siblingKey) {
            this.siblings.add(new ResearchEntryKey(siblingKey));
            return this;
        }

        public Builder siblingEnchantment(Holder<Enchantment> runeEnchantment) {
            this.siblings.add(new RuneEnchantmentKey(runeEnchantment));
            return this;
        }

        public Builder requirement(AbstractRequirement<?> req) {
            this.requirements.add(req);
            return this;
        }

        public Builder requiredCraft(ItemStack stack) {
            return this.requirement(new ResearchRequirement(new StackCraftedKey(stack.copy())));
        }

        public Builder requiredCraft(ItemLike item) {
            return this.requiredCraft(new ItemStack((ItemLike)item.asItem()));
        }

        public Builder requiredCraft(TagKey<Item> tag) {
            return this.requirement(new ResearchRequirement(new TagCraftedKey(tag)));
        }

        public Builder requiredItem(ItemStack stack) {
            return this.requirement(new ItemStackRequirement(stack.copy()));
        }

        public Builder requiredItem(ItemLike item, int count) {
            return this.requiredItem(new ItemStack((ItemLike)item.asItem(), count));
        }

        public Builder requiredItem(ItemLike item) {
            return this.requiredItem(item, 1);
        }

        public Builder requiredItem(TagKey<Item> tag, int count) {
            return this.requirement(new ItemTagRequirement(tag, count));
        }

        public Builder requiredItem(TagKey<Item> tag) {
            return this.requiredItem(tag, 1);
        }

        public Builder requiredResearch(ResourceKey<ResearchEntry> entryKey) {
            return this.requirement(new ResearchRequirement(new ResearchEntryKey(entryKey)));
        }

        public Builder requiredKnowledge(KnowledgeType type, int levels) {
            return this.requirement(new KnowledgeRequirement(type, levels));
        }

        public Builder requiredStat(Stat stat, int value) {
            return this.requirement(new StatRequirement(stat, value));
        }

        public Builder attunement(SourceList sources) {
            this.attunements.with(sources);
            return this;
        }

        public Builder attunement(Source source, int amount) {
            this.attunements.with(source, amount);
            return this;
        }

        protected String getTextTranslationKey() {
            return String.join((CharSequence)".", "research", this.modId.toLowerCase(), this.parentKey.getRootKey().location().getPath().toLowerCase(), "text", "addenda", Integer.toString(this.addendumIndex));
        }

        protected Optional<AbstractRequirement<?>> getFinalRequirement() {
            if (this.requirements.isEmpty()) {
                return Optional.empty();
            }
            if (this.requirements.size() == 1) {
                return Optional.of(this.requirements.get(0));
            }
            return Optional.of(new AndRequirement(this.requirements));
        }

        private void validate() {
            if (this.modId.isBlank()) {
                throw new IllegalStateException("Mod ID may not be empty");
            }
            if (this.addendumIndex < 0) {
                throw new IllegalStateException("Addendum index must be non-negative");
            }
        }

        ResearchAddendum build() {
            this.validate();
            return new ResearchAddendum(this.parentKey, this.getTextTranslationKey(), this.getFinalRequirement(), this.recipes, this.siblings, this.attunements.build());
        }

        public ResearchEntry.Builder end() {
            return this.entryBuilder;
        }
    }
}

