/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research;

import com.mojang.serialization.Codec;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

public enum KnowledgeType implements StringRepresentable
{
    OBSERVATION(0, "observation", 16, ResourceUtils.loc("textures/research/knowledge_observation.png")),
    THEORY(1, "theory", 32, ResourceUtils.loc("textures/research/knowledge_theory.png"));

    private static final IntFunction<KnowledgeType> BY_ID;
    public static final Codec<KnowledgeType> CODEC;
    public static final StreamCodec<ByteBuf, KnowledgeType> STREAM_CODEC;
    private final int id;
    private final String name;
    private final short progression;
    private final ResourceLocation iconLocation;

    private KnowledgeType(int id, @Nonnull String name, int progression, ResourceLocation iconLocation) {
        this.id = id;
        this.name = name;
        this.progression = (short)progression;
        this.iconLocation = iconLocation;
    }

    public int getId() {
        return this.id;
    }

    public int getProgression() {
        return this.progression;
    }

    @Nonnull
    public ResourceLocation getIconLocation() {
        return this.iconLocation;
    }

    @Nonnull
    public String getNameTranslationKey() {
        return String.join((CharSequence)".", "knowledge_type", "primalmagick", this.getSerializedName());
    }

    public String getSerializedName() {
        return this.name;
    }

    @Nullable
    public static KnowledgeType fromName(@Nullable String name) {
        for (KnowledgeType knowledgeType : KnowledgeType.values()) {
            if (!knowledgeType.getSerializedName().equals(name)) continue;
            return knowledgeType;
        }
        return null;
    }

    static {
        BY_ID = ByIdMap.continuous(KnowledgeType::getId, (Object[])KnowledgeType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        CODEC = StringRepresentable.fromValues(KnowledgeType::values);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, KnowledgeType::getId);
    }
}

