/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.research.KnowledgeType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ExtraCodecs;

public class Knowledge {
    public static final Codec<Knowledge> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)KnowledgeType.CODEC.fieldOf("type").forGetter(k -> k.type), (App)ExtraCodecs.POSITIVE_INT.fieldOf("amount").forGetter(k -> k.amount)).apply((Applicative)instance, Knowledge::new));
    protected KnowledgeType type;
    protected int amount;

    protected Knowledge(@Nonnull KnowledgeType type, int amount) {
        this.type = type;
        this.amount = amount;
    }

    @Nullable
    public static Knowledge parse(@Nullable String str) {
        String[] tokens;
        if (str != null && (tokens = str.split(";")).length == 2) {
            int amount;
            KnowledgeType type;
            try {
                type = KnowledgeType.valueOf(tokens[0].toUpperCase());
            }
            catch (Exception e) {
                return null;
            }
            try {
                amount = Integer.parseInt(tokens[1]);
            }
            catch (NumberFormatException e) {
                amount = 0;
            }
            if (type != null && amount > 0) {
                return new Knowledge(type, amount);
            }
        }
        return null;
    }

    @Nonnull
    public KnowledgeType getType() {
        return this.type;
    }

    public int getAmount() {
        return this.amount;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.type.name());
        builder.append(";");
        builder.append(this.amount);
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.amount;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Knowledge other = (Knowledge)obj;
        if (this.amount != other.amount) {
            return false;
        }
        return this.type == other.type;
    }
}

